/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.album.ui.viewholder;

import android.app.Activity;
import android.support.annotation.IdRes;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import com.xdja.im.lib.album.ImagePickerManager;
import com.xdja.im.lib.album.bean.ImageItem;
import com.xdja.im.lib.album.listener.OnItemClickListener;
import com.xdja.im.lib.album.listener.OnItemDataChangedListener;

public abstract class BaseViewHolder
extends RecyclerView.ViewHolder {
    public Activity mActivity;
    public View mItemView;
    protected OnItemClickListener mItemClickListener;
    protected OnItemDataChangedListener mItemDataChangedListener;
    public int mImageSize;

    public abstract void bindData(ImageItem var1);

    public BaseViewHolder(Activity activity, View itemView) {
        super(itemView);
        this.mActivity = activity;
        this.mItemView = itemView;
        this.mImageSize = this.getImageItemWidth((Activity)itemView.getContext());
        itemView.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, this.mImageSize));
    }

    protected View findViewById(@IdRes int id2) {
        return this.itemView.findViewById(id2);
    }

    private int getImageItemWidth(Activity activity) {
        int screenWidth = activity.getResources().getDisplayMetrics().widthPixels;
        int densityDpi = activity.getResources().getDisplayMetrics().densityDpi;
        int cols = screenWidth / densityDpi;
        int columnNum = ImagePickerManager.getInstance().getConfig().getColumnNum();
        cols = cols < columnNum ? columnNum : cols;
        int columnSpace = (int)((float)(columnNum - 1) * activity.getResources().getDisplayMetrics().density);
        return (screenWidth - columnSpace * (cols - 1)) / cols;
    }

    public void setOnItemClickListener(OnItemClickListener itemClickListener) {
        this.mItemClickListener = itemClickListener;
    }

    public void setOnItemDataChangedListener(OnItemDataChangedListener itemDataChangedListener) {
        this.mItemDataChangedListener = itemDataChangedListener;
    }
}

