/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.audio.manager;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AppOpsManager;
import android.content.Context;
import android.media.MediaRecorder;
import android.os.Build;
import android.os.Handler;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.UUID;

public class AudioManager {
    private static final int VERSION = Build.VERSION.SDK_INT;
    private MediaRecorder mMediaRecorder;
    private String mDir;
    private String mCurrentFilePath;
    private static final int REC_LENGTH = 60000;
    private boolean isPrepare;
    private Context mContext;
    private AppOpsManager mAppOpsManager;
    private Method mCheckOpMethod;
    private Handler mHandler = new Handler();
    public int EXCEPTION = 1;
    public int ILLEGALSTATE_EXCEPTION = 2;
    private Activity mActivity;
    public AudioStateListener mAudioStateListener;

    @SuppressLint(value={"InlinedApi"})
    public AudioManager(Context context, String dir) {
        this.mDir = dir;
        this.mContext = context;
        if (VERSION >= 19) {
            this.mAppOpsManager = (AppOpsManager)this.mContext.getSystemService("appops");
            this.mCheckOpMethod = this.obtainOpsMethod(this.mAppOpsManager);
        }
    }

    public void setActivity(Activity activity) {
        this.mActivity = activity;
    }

    public void setOnAudioStateListener(AudioStateListener listener) {
        this.mAudioStateListener = listener;
    }

    private Method obtainOpsMethod(AppOpsManager opm) {
        try {
            Class<?> appOpsClass = opm.getClass();
            return appOpsClass.getDeclaredMethod("checkOp", Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void prepareAudio() {
        block10: {
            try {
                this.isPrepare = false;
                File dir = new File(this.mDir);
                if (!dir.exists() && !dir.mkdirs()) {
                    LogUtil.e("prepare audio failed. create path error.");
                    return;
                }
                String fileName = this.generateFileName();
                File file = new File(dir, fileName);
                this.mCurrentFilePath = file.getAbsolutePath();
                this.release();
                this.mMediaRecorder = new MediaRecorder();
                this.mMediaRecorder.setOutputFile(file.getAbsolutePath());
                this.mMediaRecorder.setAudioSource(1);
                this.mMediaRecorder.setOutputFormat(0);
                this.mMediaRecorder.setAudioEncoder(0);
                this.mMediaRecorder.setMaxDuration(60000);
                long beginTime = System.currentTimeMillis();
                this.mMediaRecorder.prepare();
                this.mMediaRecorder.start();
                long endTime = System.currentTimeMillis();
                if (endTime - beginTime > 500L) {
                    this.mAudioStateListener.checkCurrentFocusView();
                    if (this.mMediaRecorder != null) {
                        this.mMediaRecorder.stop();
                        this.mMediaRecorder.reset();
                    }
                    break block10;
                }
                if (this.mAudioStateListener != null) {
                    this.mAudioStateListener.wellPrepared();
                }
                this.isPrepare = true;
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                this.prepareFaild(this.ILLEGALSTATE_EXCEPTION);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.prepareFaild(this.EXCEPTION);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.prepareFaild(this.EXCEPTION);
            }
        }
    }

    private void prepareFaild(final int exceptionType) {
        this.isPrepare = false;
        this.release();
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (AudioManager.this.mAudioStateListener != null) {
                    AudioManager.this.mAudioStateListener.prepareFailed(exceptionType);
                }
            }
        });
    }

    private String generateFileName() {
        return UUID.randomUUID().toString();
    }

    public synchronized double getAmplitude() {
        try {
            if (this.isPrepare && this.mMediaRecorder != null) {
                return this.mMediaRecorder.getMaxAmplitude();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1.0;
    }

    public synchronized void release() {
        try {
            if (this.mMediaRecorder != null) {
                this.mMediaRecorder.stop();
                this.mMediaRecorder.reset();
                this.mMediaRecorder.release();
                this.mMediaRecorder = null;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (this.mMediaRecorder != null) {
                this.mMediaRecorder = null;
            }
        }
    }

    public synchronized void cancel() {
        this.release();
        if (this.mCurrentFilePath != null) {
            File file = new File(this.mCurrentFilePath);
            if (!file.delete()) {
                LogUtil.e("delete recorder cache file error.");
            }
            this.mCurrentFilePath = null;
        }
    }

    public String getCurrentFilePath() {
        return this.mCurrentFilePath;
    }

    public static interface AudioStateListener {
        public void wellPrepared();

        public void prepareFailed(int var1);

        public void checkCurrentFocusView();
    }
}

