/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.audio.player;

import com.xdja.im.lib.audio.manager.VoicePlayState;
import com.xdja.im.lib.audio.player.AudioListener;
import java.util.ArrayList;
import java.util.List;

public class AudioListenerManager {
    private static AudioListenerManager INSTANCE;
    private List<AudioListener> listeners = new ArrayList<AudioListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AudioListenerManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<AudioListenerManager> clazz = AudioListenerManager.class;
        synchronized (AudioListenerManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new AudioListenerManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private AudioListenerManager() {
    }

    public void addListener(AudioListener listener) {
        if (this.listeners != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(AudioListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void clearAll() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
    }

    public void playStateChange(String filePath, VoicePlayState state, Object ... args) {
        if (this.listeners != null && this.listeners.size() > 0) {
            for (AudioListener listener : this.listeners) {
                this.dispatchPlayingState(listener, filePath, state, args);
            }
        }
    }

    private void dispatchPlayingState(AudioListener listener, String filePath, VoicePlayState state, Object ... args) {
        if (listener == null) {
            return;
        }
        switch (state) {
            case PLAYING: {
                listener.playingCallback(filePath, args);
                break;
            }
            case ERROR: {
                listener.playingErrorCallback(filePath, args);
                break;
            }
            case COMPLETION: {
                listener.playingCompletionCallback(filePath, args);
                break;
            }
            case STOP: {
                listener.playingStopCallback(filePath, args);
            }
        }
    }
}

