/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.audio.player;

import android.media.MediaPlayer;
import android.text.TextUtils;
import com.xdja.im.lib.audio.manager.VoicePlayState;
import com.xdja.im.lib.audio.player.AudioListenerManager;
import com.xdja.im.lib.video.utils.AudioFunctions;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class AudioPlayerManager {
    private MediaPlayer player;
    private String playPath;
    private Object[] args;
    private MediaPlayer.OnErrorListener errorListener = new MediaPlayer.OnErrorListener(){

        public boolean onError(MediaPlayer mp, int what, int extra) {
            AudioPlayerManager.this.stopToPlay(VoicePlayState.ERROR, AudioPlayerManager.this.args);
            return false;
        }
    };
    private MediaPlayer.OnCompletionListener completionListener = new MediaPlayer.OnCompletionListener(){

        public void onCompletion(MediaPlayer mp) {
            AudioPlayerManager.this.stopToPlay(VoicePlayState.COMPLETION, AudioPlayerManager.this.args);
        }
    };

    public static AudioPlayerManager getInstance() {
        return SingletonInstance.INSTANCE;
    }

    private AudioPlayerManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startToPlay(String filePath, Object ... args) {
        if (!this.checkNullForPath(filePath)) {
            return;
        }
        if (this.player != null) {
            if (this.player.isPlaying()) {
                this.stopToPlay(VoicePlayState.STOP, args);
            } else {
                this.player.release();
            }
            this.player = null;
        }
        FileInputStream fis = null;
        this.player = new MediaPlayer();
        this.player.setAudioStreamType(3);
        this.player.setOnErrorListener(this.errorListener);
        this.player.setOnCompletionListener(this.completionListener);
        if (TextUtils.equals((CharSequence)this.playPath, (CharSequence)filePath)) {
            this.stopToPlay(VoicePlayState.STOP, args);
            AudioFunctions.muteAudioFocus(false);
            return;
        }
        AudioFunctions.muteAudioFocus(true);
        try {
            File file = new File(filePath);
            fis = new FileInputStream(file);
            this.player.setDataSource(fis.getFD());
            this.player.prepare();
            this.player.start();
            this.playPath = filePath;
            this.args = args;
            AudioListenerManager.getInstance().playStateChange(this.playPath, VoicePlayState.PLAYING, args);
        }
        catch (Exception e) {
            LogUtil.e("ERROR:Play voice failed. " + e.getMessage());
            this.stopToPlay(VoicePlayState.ERROR, args);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean checkNullForPath(String filePath) {
        if (filePath == null || TextUtils.isEmpty((CharSequence)filePath)) {
            return false;
        }
        File file = new File(filePath);
        return file.exists();
    }

    public synchronized void stopToPlay(VoicePlayState state, Object ... args) {
        if (this.player != null) {
            try {
                if (this.player.isPlaying()) {
                    this.player.stop();
                }
                this.player.release();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            this.player = null;
            AudioFunctions.muteAudioFocus(false);
        }
        this.playPath = null;
        this.args = null;
        AudioListenerManager.getInstance().playStateChange(this.playPath, state, args);
    }

    public void stopPlay() {
        this.stopToPlay(VoicePlayState.STOP, this.args);
    }

    public void releasePlayer() {
        this.stopToPlay(VoicePlayState.STOP, new Object[0]);
        if (this.player != null) {
            this.player.release();
            this.player = null;
        }
    }

    public String getCurrentPlayPath() {
        return this.playPath;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public boolean isPlaying() {
        return this.player != null && this.player.isPlaying() && !TextUtils.isEmpty((CharSequence)this.playPath) && this.args != null && this.args.length > 0;
    }

    private static class SingletonInstance {
        private static final AudioPlayerManager INSTANCE = new AudioPlayerManager();

        private SingletonInstance() {
        }
    }
}

