/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.emoji.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import com.xdja.im.lib.emoji.ui.adapter.GridViewAdapter;
import com.xdja.im.lib.emoji.ui.adapter.ViewPageAdapter;
import com.xdja.im.uikit.R;
import java.util.ArrayList;

public class EmotionGridView
extends LinearLayout {
    private ViewPager mViewPager;
    private LinearLayout mDotLayout;
    private ImageView[] mDots;
    private int mCurrentIndex;
    private int mPagerSize;
    private OnFaceGridViewItemClick onFaceGridViewItemClick;

    public EmotionGridView(Context context) {
        this(context, null);
    }

    public EmotionGridView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initViewPage();
        this.initFootDots();
    }

    private void initViewPage() {
        this.setOrientation(1);
        int backColor = 13422544;
        this.setBackgroundColor(backColor);
        this.mViewPager = new ViewPager(this.getContext());
        this.mViewPager.setOffscreenPageLimit(4);
        this.mViewPager.setOverScrollMode(2);
        LinearLayout.LayoutParams pagerParams = new LinearLayout.LayoutParams(-1, -1);
        pagerParams.weight = 1.0f;
        pagerParams.bottomMargin = 18;
        this.mViewPager.setLayoutParams((ViewGroup.LayoutParams)pagerParams);
        this.addView((View)this.mViewPager);
        this.mDotLayout = new LinearLayout(this.getContext());
        LinearLayout.LayoutParams dotParams = new LinearLayout.LayoutParams(-1, -2);
        dotParams.bottomMargin = 5;
        this.mDotLayout.setLayoutParams((ViewGroup.LayoutParams)dotParams);
        this.mDotLayout.setGravity(1);
        this.mDotLayout.setOrientation(0);
        this.addView((View)this.mDotLayout);
    }

    private void initFootDots() {
        int i;
        double pageItemCount = 20.0;
        this.mPagerSize = (int)Math.ceil(60.0 / pageItemCount);
        if (0 < this.mPagerSize) {
            if (this.mPagerSize == 1) {
                this.mDotLayout.setVisibility(8);
            } else {
                this.mDotLayout.setVisibility(0);
                for (i = 0; i < this.mPagerSize; ++i) {
                    ImageView image = new ImageView(this.getContext());
                    image.setTag((Object)i);
                    LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(20, 20);
                    params.setMargins(5, 5, 5, (int)this.getResources().getDimension(R.dimen.im_uikit_face_layout_imageview_margin));
                    image.setBackgroundResource(R.drawable.im_uikit_dots_set);
                    image.setEnabled(false);
                    this.mDotLayout.addView((View)image, (ViewGroup.LayoutParams)params);
                }
            }
        }
        if (1 != this.mPagerSize) {
            this.mDots = new ImageView[this.mPagerSize];
            for (i = 0; i < this.mPagerSize; ++i) {
                this.mDots[i] = (ImageView)this.mDotLayout.getChildAt(i);
                this.mDots[i].setEnabled(true);
                this.mDots[i].setTag((Object)i);
            }
            this.mCurrentIndex = 0;
            this.mDots[this.mCurrentIndex].setEnabled(false);
            this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

                public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                }

                public void onPageSelected(int position) {
                    EmotionGridView.this.setCurDot(position);
                }

                public void onPageScrollStateChanged(int state) {
                }
            });
        }
    }

    private void setCurDot(int position) {
        if (position < 0 || position > this.mPagerSize - 1 || this.mCurrentIndex == position) {
            return;
        }
        this.mDots[position].setEnabled(false);
        this.mDots[this.mCurrentIndex].setEnabled(true);
        this.mCurrentIndex = position;
    }

    public void setAdapter() {
        if (this.onFaceGridViewItemClick == null) {
            return;
        }
        ArrayList<GridView> views = new ArrayList<GridView>();
        for (int i = 0; i < this.mPagerSize; ++i) {
            views.add(this.getViewPagerItem(i));
        }
        this.mViewPager.setAdapter((PagerAdapter)new ViewPageAdapter(views));
    }

    @SuppressLint(value={"DefaultLocale"})
    private String[] getGridViewData(int index) {
        String backBtnName;
        int startPos = (++index - 1) * 20;
        int endPos = index * 20;
        if (endPos > 60) {
            endPos = 59;
        }
        int length = endPos - startPos + 1;
        String[] tmps = new String[length];
        int num = 0;
        for (int i = startPos; i < endPos; ++i) {
            tmps[num] = "sticker/emotion/emoji_" + String.format("%03d", i) + ".png";
            ++num;
        }
        tmps[length - 1] = backBtnName = "back_normal";
        return tmps;
    }

    private GridView getViewPagerItem(int index) {
        final GridView gridView = new GridView(this.getContext());
        gridView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        gridView.setNumColumns(7);
        gridView.setSelector(R.drawable.im_uikit_transparent);
        gridView.setVerticalScrollBarEnabled(false);
        gridView.setHorizontalScrollBarEnabled(false);
        gridView.setBackgroundColor(0);
        gridView.setAdapter((ListAdapter)new GridViewAdapter(this.getContext(), this.getGridViewData(index)));
        gridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (position == gridView.getChildCount() - 1) {
                    EmotionGridView.this.onFaceGridViewItemClick.onClear();
                } else {
                    EmotionGridView.this.onFaceGridViewItemClick.onItemClick(EmotionGridView.this.mCurrentIndex * 20 + position);
                }
            }
        });
        return gridView;
    }

    public void setOnFaceGridViewItemClick(OnFaceGridViewItemClick onFaceGridViewItemClick) {
        this.onFaceGridViewItemClick = onFaceGridViewItemClick;
    }

    public static interface OnFaceGridViewItemClick {
        public void onItemClick(int var1);

        public void onClear();
    }
}

