/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.file.ui.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import com.xdja.im.core.repository.interf.ProxyRepository;
import com.xdja.im.lib.file.FileExplorerManager;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.file.bean.FileListType;
import com.xdja.im.lib.file.ui.adapter.CommonRecyclerAdapter;
import com.xdja.im.lib.file.ui.adapter.FileExplorerFragmentAdapter;
import com.xdja.im.lib.file.ui.presenter.FileListFragmentPresenter;
import com.xdja.im.lib.file.ui.view.ViewChildFileDelegate;
import com.xdja.im.lib.file.ui.view.ViewChildPhotoDelegate;
import com.xdja.im.lib.file.ui.view.ViewDirTitleDelegate;
import com.xdja.im.lib.file.ui.view.ViewFileList;
import com.xdja.im.lib.file.ui.view.vu.FileListVu;
import com.xdja.im.uikit.base.ImBaseFragment;
import com.xdja.im.uikit.utils.log.LogUtil;
import dagger.Lazy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import rx.Subscriber;

public class FileListFragment
extends ImBaseFragment<FileListFragmentPresenter, FileListVu>
implements FileListFragmentPresenter {
    private int type;
    private FileListType[] childTabLists = new FileListType[]{FileListType.VIDEO, FileListType.PHOTO, FileListType.DOCUMENT, FileListType.APK, FileListType.OTHER};
    @Inject
    Lazy<ProxyRepository> mRepository;
    private FileExplorerFragmentAdapter adapter;
    private Map<String, List<FileItem>> dataMaps = new HashMap<String, List<FileItem>>();
    private CommonRecyclerAdapter fragmentAdapter;

    public static FileListFragment newInstance(Bundle bundle) {
        FileListFragment fragment = new FileListFragment();
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    protected Class<? extends FileListVu> getVuClass() {
        return ViewFileList.class;
    }

    @Override
    @NonNull
    protected FileListFragmentPresenter getPresenter() {
        return this;
    }

    @Override
    protected void preBindView(Bundle savedInstanceState) {
        super.preBindView(savedInstanceState);
        Bundle bundle = this.getArguments();
        this.type = bundle.getInt("tab_type");
    }

    @Override
    protected void onBindView(Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        if (this.mComponent == null) {
            return;
        }
        this.mComponent.inject(this);
        this.bindViews();
    }

    private void bindViews() {
        ((FileListVu)this.getVu()).showViewWithType(this.type);
        this.initFragmentAdapter(this.type);
        if (this.type == FileListType.LOCAL.getType()) {
            this.bindLocalFragmentView();
        } else {
            this.bindFragmentView(this.type);
        }
    }

    private void initFragmentAdapter(int type) {
        this.fragmentAdapter = new CommonRecyclerAdapter((Context)this.getActivity(), null, this.dataMaps);
        this.fragmentAdapter.addItemViewDelegate(0, new ViewDirTitleDelegate(type));
        int photoStyle = FileExplorerManager.getInstance().getConfig().getPhotoStyle();
        if (type == FileListType.PHOTO.getType() && photoStyle == 2) {
            this.fragmentAdapter.addItemViewDelegate(1, new ViewChildPhotoDelegate());
        } else {
            this.fragmentAdapter.addItemViewDelegate(3, new ViewChildFileDelegate());
        }
        this.fragmentAdapter.setRecyclerView(((FileListVu)this.getVu()).getRecyclerView());
        this.fragmentAdapter.setLayoutManager(3);
        ((FileListVu)this.getVu()).setRecyclerViewAdapter(this.fragmentAdapter);
    }

    private void bindFragmentView(int type) {
        if (type == FileListType.RECENT.getType()) {
            ((FileListVu)this.getVu()).showEmptyView(false);
        }
        FileListType tabType = this.findFileListTypeWithType(type);
        ((ProxyRepository)this.mRepository.get()).queryRecentAndLocalFile(tabType, new Subscriber<Map<String, List<FileItem>>>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                ((FileListVu)FileListFragment.this.getVu()).showEmptyView(true);
                LogUtil.d("obtain msg error:" + e.getMessage());
            }

            public void onNext(Map<String, List<FileItem>> stringListMap) {
                if (stringListMap.size() == 0) {
                    ((FileListVu)FileListFragment.this.getVu()).showEmptyView(true);
                } else {
                    FileListFragment.this.dataMaps.putAll(stringListMap);
                    FileListFragment.this.fragmentAdapter.updateAllItems();
                }
            }
        });
    }

    private FileListType findFileListTypeWithType(int type) {
        if (type == FileListType.RECENT.getType()) {
            return FileListType.RECENT;
        }
        if (type == FileListType.VIDEO.getType()) {
            return FileListType.VIDEO;
        }
        if (type == FileListType.PHOTO.getType()) {
            return FileListType.PHOTO;
        }
        if (type == FileListType.DOCUMENT.getType()) {
            return FileListType.DOCUMENT;
        }
        if (type == FileListType.APK.getType()) {
            return FileListType.APK;
        }
        if (type == FileListType.OTHER.getType()) {
            return FileListType.OTHER;
        }
        return FileListType.NON;
    }

    private void bindLocalFragmentView() {
        Bundle bundle = null;
        ArrayList<Fragment> fragments = new ArrayList<Fragment>();
        for (FileListType listType : this.childTabLists) {
            bundle = new Bundle();
            bundle.putInt("tab_type", listType.getType());
            fragments.add(FileListFragment.newInstance(bundle));
        }
        this.adapter = this.buildAdapter(this.childTabLists, fragments);
        ((FileListVu)this.getVu()).setFragmentAdapter(this.adapter);
    }

    private FileExplorerFragmentAdapter buildAdapter(final FileListType[] titles, List<Fragment> fragments) {
        return new FileExplorerFragmentAdapter<FileListType>(this.getChildFragmentManager(), (Context)this.getActivity(), titles, fragments){

            public CharSequence getPageTitle(int position) {
                return this.context.getString(titles[position].getResId());
            }
        };
    }
}

