/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.file.ui.view;

import com.xdja.im.common.utils.DateUtils;
import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.core.utils.IMFileTools;
import com.xdja.im.lib.file.bean.FileCollections;
import com.xdja.im.lib.file.bean.FileItem;
import com.xdja.im.lib.file.bean.FileItemNode;
import com.xdja.im.lib.file.widget.recyclerview.ItemViewDelegate;
import com.xdja.im.lib.file.widget.recyclerview.ViewHolder;
import com.xdja.im.uikit.R;

public class ViewChildFileDelegate
implements ItemViewDelegate<FileItemNode> {
    @Override
    public int getItemViewLayoutId() {
        return R.layout.im_uikit_fragment_file_item;
    }

    @Override
    public boolean isForViewType(FileItemNode item, int position) {
        return item.isLeaf();
    }

    @Override
    public void covert(ViewHolder viewHolder, FileItemNode fileItemNode, int position) {
        FileItem fileItem = (FileItem)fileItemNode.getValue();
        viewHolder.setText(R.id.tv_file_fragment_titile, fileItem.getFileName());
        String sizeStr = FileSizeUtils.formatFileSize(fileItem.getFileSize());
        viewHolder.setText(R.id.tv_file_fragment_size, sizeStr);
        String dateModify = DateUtils.convertFileModifyDate(fileItem.getModifiedDate());
        viewHolder.setText(R.id.tv_file_fragment_date, dateModify);
        if (FileCollections.getInstance().getAllSelectFiles().contains(fileItem)) {
            viewHolder.setChecked(R.id.chx_file_fragment_select, true);
        } else {
            viewHolder.setChecked(R.id.chx_file_fragment_select, fileItem.isSelected());
        }
        this.getIconResIdByPath(viewHolder, fileItem.getFilePath());
    }

    private void getIconResIdByPath(ViewHolder holder, String filePath) {
        int showType = IMFileTools.getFileTypeFromFilepath(filePath);
        if (showType == 3) {
            holder.setImageWithPath(R.id.img_file_fragment, filePath, R.mipmap.im_uikit_ic_jpg);
        } else {
            holder.setImageWithResource(R.id.img_file_fragment, IMFileTools.getFileIconResId(showType));
        }
    }
}

