/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.file.ui.view;

import android.content.Context;
import android.graphics.Color;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.xdja.im.common.utils.FileSizeUtils;
import com.xdja.im.lib.file.ui.presenter.FileExplorerPresenter;
import com.xdja.im.lib.file.ui.view.vu.FileExplorerVu;
import com.xdja.im.lib.file.widget.ViewPagerIndicator;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImActivitySuperView;

public class ViewFileExplorer
extends ImActivitySuperView<FileExplorerPresenter>
implements FileExplorerVu {
    private ViewPager viewPager;
    private ViewPagerIndicator indicator;
    private ProgressBar progressBar;
    private TextView mSelectedFileSizeTv;
    private Button mSendBtn;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_activity_file_explorer;
    }

    @Override
    protected int getToolbarType() {
        return 0;
    }

    @Override
    protected int getToolbarTitle() {
        return R.string.im_uikit_select_file;
    }

    @Override
    protected void injectView() {
        super.injectView();
        View view = this.getView();
        if (view != null) {
            this.viewPager = (ViewPager)view.findViewById(R.id.file_parent_vp);
            this.indicator = (ViewPagerIndicator)view.findViewById(R.id.file_parent_indicator);
            this.mSelectedFileSizeTv = (TextView)view.findViewById(R.id.tv_file_select_size);
            this.mSendBtn = (Button)view.findViewById(R.id.btn_send);
            this.progressBar = (ProgressBar)view.findViewById(R.id.pb_loading);
            this.mSendBtn.setEnabled(false);
        }
    }

    @Override
    public void setAdapter(FragmentPagerAdapter adapter) {
        this.viewPager.setAdapter((PagerAdapter)adapter);
        this.indicator.setViewPager(this.viewPager);
    }

    @Override
    public void setCurrentSelectedFileSize(Context context, long size) {
        this.mSelectedFileSizeTv.setText((CharSequence)String.format(context.getString(R.string.im_uikit_file_select_size), FileSizeUtils.formatFileSize(size)));
    }

    @Override
    public void setCurrentSelectedFileCount(Context context, int selectCount) {
        if (selectCount == 0) {
            this.mSendBtn.setText(R.string.im_uikit_send);
            this.mSendBtn.setClickable(false);
            this.mSendBtn.setEnabled(false);
            this.mSendBtn.setTextColor(Color.parseColor((String)"#77000000"));
        } else {
            this.mSendBtn.setClickable(true);
            this.mSendBtn.setEnabled(true);
            this.mSendBtn.setTextColor(Color.parseColor((String)"#F3000000"));
            this.mSendBtn.setText((CharSequence)String.format(context.getString(R.string.im_uikit_send_indicator), selectCount));
        }
    }

    @Override
    public void setProgressBarVisibility(int visibility) {
        this.progressBar.setVisibility(visibility);
    }
}

