/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.file.widget.recyclerview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.xdja.im.lib.file.widget.recyclerview.ItemViewDelegate;
import com.xdja.im.lib.file.widget.recyclerview.ItemViewDelegateManager;
import com.xdja.im.lib.file.widget.recyclerview.ViewHolder;
import java.util.List;

public class BaseMultiItemTypeAdapter<T>
extends RecyclerView.Adapter<ViewHolder> {
    protected Context context;
    protected List<T> dataSources;
    private OnItemClickListener clickListener;
    private ItemViewDelegateManager delegateManager;

    public BaseMultiItemTypeAdapter(Context context, List<T> dataSources) {
        this.context = context;
        this.dataSources = dataSources;
        this.delegateManager = new ItemViewDelegateManager();
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        ItemViewDelegate delegate = this.delegateManager.getItemViewDelegate(viewType);
        int layoutId = delegate.getItemViewLayoutId();
        ViewHolder holder = ViewHolder.createViewHolder(this.context, parent, layoutId);
        this.onViewCreated(holder, holder.getConvertView());
        this.setListener(parent, holder, viewType);
        return holder;
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        this.convert(holder, this.dataSources.get(position));
    }

    protected void setListener(ViewGroup parent, final ViewHolder holder, int viewType) {
        holder.getConvertView().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (BaseMultiItemTypeAdapter.this.clickListener != null) {
                    int position = holder.getAdapterPosition();
                    BaseMultiItemTypeAdapter.this.clickListener.onItemClick(holder.getConvertView(), holder, position);
                }
            }
        });
        holder.getConvertView().setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (BaseMultiItemTypeAdapter.this.clickListener != null) {
                    int position = holder.getAdapterPosition();
                    return BaseMultiItemTypeAdapter.this.clickListener.onItemLongClick(holder.getConvertView(), holder, position);
                }
                return false;
            }
        });
    }

    protected void onViewCreated(ViewHolder holder, View currentView) {
    }

    public void convert(ViewHolder holder, T t) {
        this.delegateManager.covert(holder, t, holder.getAdapterPosition());
    }

    public int getItemViewType(int position) {
        if (!this.useDelegateManager()) {
            return super.getItemViewType(position);
        }
        return this.delegateManager.getItemViewType(this.dataSources.get(position), position);
    }

    public int getItemCount() {
        return this.dataSources != null ? this.dataSources.size() : 0;
    }

    public boolean useDelegateManager() {
        return this.delegateManager.getItemViewDelegateCount() > 0;
    }

    public void addItemViewDelegate(ItemViewDelegate<T> delegate) {
        this.delegateManager.addDelegate(delegate);
    }

    public void addItemViewDelegate(int viewType, ItemViewDelegate<T> delegate) {
        this.delegateManager.addDelegate(viewType, delegate);
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.clickListener = listener;
    }

    public static interface OnItemClickListener {
        public void onItemClick(View var1, ViewHolder var2, int var3);

        public boolean onItemLongClick(View var1, ViewHolder var2, int var3);
    }
}

