/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.lib.video.manager;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.hardware.Camera;
import android.media.MediaMetadataRetriever;
import android.media.MediaRecorder;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import com.xdja.im.core.utils.FilePathUtils;
import com.xdja.im.lib.video.palyer.VideoPlayerHelper;
import com.xdja.im.lib.video.recorder.VideoRecorderHelper;
import com.xdja.im.lib.video.utils.AudioFunctions;
import com.xdja.im.lib.video.utils.CameraHelper;
import com.xdja.im.uikit.utils.log.LogUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.UUID;

public class VideoManager
implements SurfaceHolder.Callback {
    private final Activity activity;
    private MediaRecorder mMediaRecorder;
    private Camera mCamera;
    private SurfaceView mSurfaceView;
    private SurfaceHolder mSurfaceHolder;
    private int previewWidth;
    private int previewHeight;
    private boolean isRecording;
    private GestureDetector mDetector;
    private boolean isZoomIn = false;
    private IVideoRecordCallback mRecordCallback;
    private boolean isFacingBack = true;
    private boolean isConfirm;
    private File videoFile;
    private File firstFrameFile;
    private VideoRecorderHelper mRecorderHelper;
    private VideoPlayerHelper mPlayerHelper;

    public void setVideoFile(File videoFile) {
        this.videoFile = videoFile;
    }

    public File getVideoFile() {
        return this.videoFile;
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public File getFirstFrameFile() {
        return this.firstFrameFile;
    }

    public void setRecordCallback(IVideoRecordCallback callback) {
        this.mRecordCallback = callback;
    }

    public VideoManager(Activity activity) {
        this.activity = activity;
    }

    public void setSurfaceView(SurfaceView view) {
        this.mSurfaceView = view;
        this.mSurfaceHolder = this.mSurfaceView.getHolder();
        this.mSurfaceHolder.addCallback((SurfaceHolder.Callback)this);
        this.mDetector = new GestureDetector((Context)this.activity, (GestureDetector.OnGestureListener)new ZoomGestureListener());
        this.mSurfaceView.setOnTouchListener(new View.OnTouchListener(){

            @SuppressLint(value={"ClickableViewAccessibility"})
            public boolean onTouch(View v, MotionEvent event) {
                VideoManager.this.mDetector.onTouchEvent(event);
                if (VideoManager.this.mCamera != null) {
                    VideoManager.this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                        public void onAutoFocus(boolean success, Camera camera) {
                            LogUtil.d("AutoFocus recorder video state" + success);
                        }
                    });
                }
                return false;
            }
        });
    }

    public void record() {
        AudioFunctions.muteAudioFocus(true);
        if (this.isRecording) {
            try {
                this.mMediaRecorder.stop();
            }
            catch (RuntimeException e) {
                LogUtil.d("RuntimeException: stop() is called immediately after start()");
            }
            this.releaseMediaRecorder();
            this.mCamera.lock();
            this.isRecording = false;
        }
        this.startRecord();
    }

    private boolean prepareRecord() {
        try {
            this.mMediaRecorder = new MediaRecorder();
            this.mCamera.unlock();
            this.mMediaRecorder.setCamera(this.mCamera);
            this.mMediaRecorder.setVideoSource(1);
            this.mMediaRecorder.setAudioSource(1);
            if (this.isFacingBack) {
                this.mMediaRecorder.setOrientationHint(90);
            } else {
                this.mMediaRecorder.setOrientationHint(270);
            }
            this.mMediaRecorder.setOutputFormat(2);
            this.mMediaRecorder.setAudioEncoder(1);
            this.mMediaRecorder.setVideoEncoder(2);
            this.mMediaRecorder.setVideoSize(this.previewWidth, this.previewHeight);
            this.mMediaRecorder.setVideoEncodingBitRate(5 * this.previewWidth * this.previewHeight);
            File videoDri = new File(FilePathUtils.getVideoPath());
            this.videoFile = new File(videoDri, this.generateFileName());
            this.mMediaRecorder.setOutputFile(this.videoFile.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.releaseMediaRecorder();
            if (this.mRecordCallback != null) {
                this.mRecordCallback.onPrepareFailed(1, e.getMessage());
            }
            return false;
        }
        try {
            this.mMediaRecorder.prepare();
        }
        catch (IllegalStateException e) {
            this.releaseMediaRecorder();
            if (this.mRecordCallback != null) {
                this.mRecordCallback.onPrepareFailed(2, e.getMessage());
            }
            return false;
        }
        catch (IOException e) {
            this.releaseMediaRecorder();
            if (this.mRecordCallback != null) {
                this.mRecordCallback.onPrepareFailed(2, e.getMessage());
            }
            return false;
        }
        return true;
    }

    public void stopRecordSave() {
        if (this.isRecording) {
            this.isRecording = false;
            try {
                this.mMediaRecorder.stop();
                this.saveFirstFrame(this.videoFile.getPath());
            }
            catch (RuntimeException runtimeException) {
            }
            finally {
                this.releaseMediaRecorder();
                this.releaseCamera();
            }
            this.confirmVideoPlay(this.videoFile.getAbsolutePath());
        }
    }

    public void stopRecordUnSave() {
        if (this.isRecording) {
            this.isRecording = false;
            try {
                this.mMediaRecorder.stop();
                if (this.videoFile.exists()) {
                    this.videoFile.delete();
                }
            }
            catch (RuntimeException runtimeException) {
            }
            finally {
                this.releaseMediaRecorder();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFirstFrame(String path) {
        MediaMetadataRetriever media = null;
        try {
            media = new MediaMetadataRetriever();
            media.setDataSource(path);
        }
        catch (IllegalArgumentException e) {
            LogUtil.e("Save first frame failed, when path of path is error");
        }
        if (media == null) {
            return;
        }
        Bitmap bitmap = media.getFrameAtTime(0L);
        String fileName = this.generateFileName();
        BufferedOutputStream bos = null;
        this.firstFrameFile = new File(FilePathUtils.getVideoPath(), fileName);
        try {
            bos = new BufferedOutputStream(new FileOutputStream(this.firstFrameFile));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 40, (OutputStream)bos);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bos != null) {
                    bos.flush();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean deleteTargetFile() {
        return this.videoFile != null && this.videoFile.delete();
    }

    private void startPreView(SurfaceHolder holder, boolean isFacingBack) {
        this.isFacingBack = isFacingBack;
        int cameraId = 0;
        if (this.mCamera == null) {
            cameraId = isFacingBack ? CameraHelper.getDefaultBackFacingCameraInstance() : CameraHelper.getDefaultFrontFacingCameraInstance();
            try {
                this.mCamera = Camera.open((int)cameraId);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.mRecordCallback != null) {
                    this.mRecordCallback.onPrepareFailed(0, e.getMessage());
                }
                return;
            }
        }
        if (this.mCamera != null) {
            int result;
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
            int rotation = this.activity.getWindowManager().getDefaultDisplay().getRotation();
            int degrees = rotation * 90;
            if (info.facing == 1) {
                result = (info.orientation + degrees) % 360;
                result = (360 - result) % 360;
            } else {
                result = (info.orientation - degrees + 360) % 360;
            }
            this.mCamera.setDisplayOrientation(result);
            try {
                this.mCamera.setPreviewDisplay(holder);
                Camera.Parameters parameters = this.mCamera.getParameters();
                List mSupportedPreviewSizes = parameters.getSupportedPreviewSizes();
                List mSupportedVideoSizes = parameters.getSupportedVideoSizes();
                Camera.Size optimalSize = CameraHelper.getOptimalVideoSize(mSupportedVideoSizes, mSupportedPreviewSizes, this.mSurfaceView.getWidth(), this.mSurfaceView.getHeight());
                this.previewWidth = optimalSize.width;
                this.previewHeight = optimalSize.height;
                if (result == 90 || result == 270) {
                    this.mSurfaceHolder.setFixedSize(this.previewHeight, this.previewWidth);
                } else {
                    this.mSurfaceHolder.setFixedSize(this.previewWidth, this.previewHeight);
                }
                CameraHelper.setCameraFocusMode("continuous-video", this.mCamera);
                this.mCamera.setParameters(parameters);
                this.mCamera.startPreview();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void releaseMediaRecorder() {
        LogUtil.d("Start release recorder.");
        if (this.mMediaRecorder != null) {
            this.mMediaRecorder.reset();
            this.mMediaRecorder.release();
            this.mMediaRecorder = null;
        }
    }

    private void releaseCamera() {
        LogUtil.d("Start release camera.");
        if (this.mCamera != null) {
            this.mCamera.release();
            this.mCamera = null;
        }
    }

    private void confirmVideoPlay(String path) {
        AudioFunctions.muteAudioFocus(true);
        this.isConfirm = true;
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        if (this.mRecordCallback != null) {
            this.mRecordCallback.completeRecord();
        }
        this.mPlayerHelper = new VideoPlayerHelper(this.mSurfaceHolder);
        this.mPlayerHelper.play(file.getAbsolutePath(), true);
    }

    public void resume() {
        this.confirmVideoPlay(this.videoFile.getPath());
    }

    public void pause() {
        if (this.mPlayerHelper != null) {
            this.mPlayerHelper.pause();
        }
    }

    public void release() {
        if (this.mPlayerHelper == null) {
            return;
        }
        if (this.mPlayerHelper.isPlaying()) {
            this.mPlayerHelper.stop();
            this.mPlayerHelper.destroy();
        }
    }

    public void stopPlay(boolean isRerecording) {
        if (this.mPlayerHelper == null) {
            return;
        }
        if (this.mPlayerHelper.isPlaying()) {
            this.mPlayerHelper.stop();
            this.mPlayerHelper.destroy();
        }
        if (isRerecording) {
            this.isConfirm = false;
            this.startPreView(this.mSurfaceHolder, this.isFacingBack);
        }
    }

    public void transformCamera() {
        this.releaseCamera();
        this.startPreView(this.mSurfaceHolder, !this.isFacingBack);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        LogUtil.d("surfaceCreated: ");
        this.mSurfaceHolder = holder;
        if (this.isConfirm) {
            this.confirmVideoPlay(this.videoFile.getAbsolutePath());
        } else {
            this.startPreView(holder, this.isFacingBack);
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.isRecording = false;
        if (this.mCamera != null) {
            this.releaseCamera();
        }
        if (this.mMediaRecorder != null) {
            this.releaseMediaRecorder();
        }
        if (this.mPlayerHelper != null) {
            this.mPlayerHelper.destroy();
        }
    }

    private void startRecord() {
        block3: {
            if (this.prepareRecord()) {
                try {
                    this.mRecordCallback.prepareRecord();
                    this.mMediaRecorder.start();
                    this.isRecording = true;
                    LogUtil.d("Start recorder video...");
                }
                catch (RuntimeException e) {
                    LogUtil.e("ERROR: Recorder video failed. " + e.getMessage());
                    this.releaseMediaRecorder();
                    if (this.mRecordCallback == null) break block3;
                    this.mRecordCallback.onPrepareFailed(3, e.getMessage());
                }
            }
        }
    }

    private String generateFileName() {
        return UUID.randomUUID().toString();
    }

    private void setZoom(int zoomValue) {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.mCamera.getParameters()).isZoomSupported()) {
            int maxZoom = parameters.getMaxZoom();
            if (maxZoom == 0) {
                return;
            }
            if (zoomValue > maxZoom) {
                zoomValue = maxZoom;
            }
            parameters.setZoom(zoomValue);
            this.mCamera.setParameters(parameters);
        }
    }

    public static interface IVideoRecordCallback {
        public void prepareRecord();

        public void completeRecord();

        public void onPrepareFailed(int var1, String var2);
    }

    private class ZoomGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private ZoomGestureListener() {
        }

        public boolean onDoubleTap(MotionEvent e) {
            super.onDoubleTap(e);
            if (!VideoManager.this.isZoomIn) {
                VideoManager.this.setZoom(20);
                VideoManager.this.isZoomIn = true;
            } else {
                VideoManager.this.setZoom(0);
                VideoManager.this.isZoomIn = false;
            }
            return true;
        }
    }
}

