/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.base;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.support.annotation.StringRes;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;
import com.xdja.im.base.frame.Presenter;
import com.xdja.im.base.frame.view.FragmentSuperBaseView;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.utils.ConvertUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class ImFragmentSuperView<P extends Presenter>
extends FragmentSuperBaseView<P> {
    private Toolbar mToolBar;
    private TextView mToolbarTitle;
    private ImageView mToolbarBack;
    private ImageView mToolbarAdd;
    private onNavigateCallback mCallback;

    @Override
    protected void injectView() {
        super.injectView();
        this.mToolBar = (Toolbar)this.findViewById(R.id.toolbar);
        this.mToolbarTitle = (TextView)this.findViewById(R.id.tv_title);
        this.mToolbarBack = (ImageView)this.findViewById(R.id.img_back);
        this.mToolbarAdd = (ImageView)this.findViewById(R.id.img_add);
    }

    private void initToolBar() {
        ((AppCompatActivity)this.getActivity()).setSupportActionBar(this.mToolBar);
        if (Build.VERSION.SDK_INT >= 19) {
            this.setTranslucentStatus(true);
            this.mToolBar.setPadding(0, this.getStatusBarHeight(), 0, 0);
        }
        switch (this.getToolbarType()) {
            case 3: {
                break;
            }
            case 0: {
                this.mToolbarBack.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (ImFragmentSuperView.this.mCallback != null) {
                            ImFragmentSuperView.this.mCallback.onBackClick();
                        }
                        ImFragmentSuperView.this.getActivity().finish();
                    }
                });
                this.mToolbarAdd.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (ImFragmentSuperView.this.mCallback != null) {
                            ImFragmentSuperView.this.mCallback.onAddClick();
                        }
                    }
                });
                break;
            }
            case 1: {
                break;
            }
        }
    }

    @TargetApi(value=19)
    private void setTranslucentStatus(boolean on) {
        Window win = this.getActivity().getWindow();
        WindowManager.LayoutParams params = this.getActivity().getWindow().getAttributes();
        int bits = 0x4000000;
        params.flags = on ? (params.flags |= 0x4000000) : (params.flags &= 0xFBFFFFFF);
        win.setAttributes(params);
    }

    protected void supportActionBar(boolean isSupport) {
        if (isSupport) {
            this.mToolBar.setVisibility(0);
            if (this.mToolBar != null) {
                this.initToolBar();
                if (this.getToolbarTitle() > 0) {
                    this.setTitle(this.getToolbarTitle());
                }
            }
        } else if (this.mToolBar != null) {
            this.mToolBar.setVisibility(8);
        }
    }

    private int getStatusBarHeight() {
        int statusBarHeight = ConvertUtils.dp2px((Context)this.getActivity(), 25.0f);
        try {
            Class<?> clazz = Class.forName("com.android.internal.R$dimen");
            Object object = clazz.newInstance();
            int height = Integer.parseInt(clazz.getField("status_bar_height").get(object).toString());
            statusBarHeight = this.getActivity().getResources().getDimensionPixelSize(height);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return statusBarHeight;
    }

    protected int getToolbarTitle() {
        return -1;
    }

    public void setTitle(@StringRes int resId) {
        if (this.mToolbarTitle != null) {
            this.mToolbarTitle.setText(resId);
        }
    }

    public void setTitle(CharSequence title) {
        if (this.mToolbarTitle != null) {
            this.mToolbarTitle.setText(title);
        }
    }

    public void setToolBarAddVisible(boolean isShow) {
        if (this.mToolbarAdd != null) {
            this.mToolbarAdd.setVisibility(isShow ? 0 : 4);
        }
    }

    public void setNavigateCallback(onNavigateCallback callback) {
        this.mCallback = callback;
    }

    protected int getToolbarType() {
        return 1;
    }

    public static interface onNavigateCallback {
        public void onBackClick();

        public void onAddClick();
    }

    public static class ToolbarDef {
        public static final int NAVIGATE_BACK = 0;
        public static final int NAVIGATE_DEFAULT = 1;
        public static final int NAVIGATE_OTHER = 2;
        public static final int NAVIGATE_CUSTOM_BACK = 3;

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface NavigateType {
        }
    }
}

