/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.squareup.otto.Subscribe;
import com.xdja.im.base.eventbus.BusProvider;
import com.xdja.im.common.utils.CommonTool;
import com.xdja.im.common.utils.SystemHelper;
import com.xdja.im.core.model.event.IMProxyFileEvent;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.core.model.message.file.NormalFileInfo;
import com.xdja.im.core.repository.interf.ProxyRepository;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.base.ImBaseActivity;
import com.xdja.im.uikit.ui.presenter.FileDownloadPresenter;
import com.xdja.im.uikit.ui.view.ViewFileDownload;
import com.xdja.im.uikit.ui.view.vu.FileDownloadVu;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.NetworkUtil;
import dagger.Lazy;
import java.io.File;
import java.util.ArrayList;
import javax.inject.Inject;
import rx.Subscriber;

public class FileDownloadActivity
extends ImBaseActivity<FileDownloadPresenter, FileDownloadVu>
implements FileDownloadPresenter {
    @Inject
    Lazy<ProxyRepository> proxyRepository;
    private TalkMessageBean mCurMessageBean;
    private NormalFileInfo mCurFileInfo;

    @Override
    @NonNull
    protected Class<? extends FileDownloadVu> getVuClass() {
        return ViewFileDownload.class;
    }

    @Override
    @NonNull
    protected FileDownloadPresenter getPresenter() {
        return this;
    }

    @Override
    protected void onBindView(Bundle savedInstanceState) {
        super.onBindView(savedInstanceState);
        if (this.mComponent == null) {
            return;
        }
        this.mComponent.inject(this);
        BusProvider.getInstance().register(this);
        Intent intent = this.getIntent();
        if (intent == null) {
            LogUtil.e("ERROR: Intent is null.");
            CommonTool.showToast(R.string.im_uikit_file_open_failed);
            return;
        }
        long msgId = intent.getLongExtra("messageId", -1L);
        if (msgId < 0L) {
            LogUtil.e("ERROR: Message id ." + msgId);
            CommonTool.showToast(R.string.im_uikit_file_open_failed);
            return;
        }
        long translateSize = intent.getLongExtra("fileTranslateSize", 0L);
        this.loadTalkMessageInfo(msgId, translateSize);
        if (!NetworkUtil.isNetworkConnected((Context)this)) {
            CommonTool.showToast(R.string.im_uikit_net_not_available);
        }
    }

    private void loadTalkMessageInfo(long msgId, final long translateSize) {
        ((ProxyRepository)this.proxyRepository.get()).getTalkMessage(msgId, new Subscriber<TalkMessageBean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                LogUtil.e("ERROR: Get message entity failed.");
                CommonTool.showToast(R.string.im_uikit_file_open_failed);
            }

            public void onNext(TalkMessageBean talkMessageBean) {
                FileDownloadActivity.this.mCurMessageBean = talkMessageBean;
                FileDownloadActivity.this.mCurFileInfo = (NormalFileInfo)talkMessageBean.getFileInfo();
                if (FileDownloadActivity.this.mCurFileInfo == null) {
                    CommonTool.showToast(R.string.im_uikit_file_open_failed);
                    return;
                }
                FileDownloadActivity.this.mCurFileInfo.setTranslateSize(Math.max(translateSize, FileDownloadActivity.this.mCurFileInfo.getTranslateSize()));
                if (FileDownloadActivity.this.mCurFileInfo.getFileState() != 4 && FileDownloadActivity.this.mCurFileInfo.getFileState() != 2) {
                    FileDownloadActivity.this.downLoadFile(true);
                }
                ((FileDownloadVu)FileDownloadActivity.this.getVu()).setData();
            }
        });
    }

    @Override
    public void downLoadFile(boolean flag) {
        if (this.mCurFileInfo.getFileState() == 3) {
            return;
        }
        if (!flag) {
            ((FileDownloadVu)this.getVu()).setCtrlBtnText(R.string.im_uikit_pause_download);
        }
        if (this.mCurFileInfo.getFileState() == 1) {
            this.startDownloadFile();
        } else {
            this.resumeDownloadFile();
        }
    }

    @Override
    public void startDownloadFile() {
        if (this.mCurMessageBean == null) {
            return;
        }
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        fileInfos.add(this.mCurFileInfo);
        this.mCurFileInfo.setFileState(3);
        ((ProxyRepository)this.proxyRepository.get()).downloadFile(fileInfos, new Subscriber<Integer>(){

            public void onCompleted() {
                LogUtil.d("downloadFile file finished.");
            }

            public void onError(Throwable e) {
                LogUtil.d("ERROR : downloadFile file error.");
            }

            public void onNext(Integer integer) {
                LogUtil.d("downloadFile file start.");
            }
        });
    }

    @Override
    public void pauseDownloadFile() {
        if (this.mCurFileInfo == null) {
            LogUtil.e("ERROR: pause download file, but file info is null.");
            return;
        }
        this.mCurFileInfo.setFileState(4);
        ((ProxyRepository)this.proxyRepository.get()).pauseFileReceiving(this.mCurFileInfo, new Subscriber<Integer>(){

            public void onCompleted() {
                LogUtil.d("Pause downloadFile file finished.");
            }

            public void onError(Throwable e) {
                LogUtil.d("ERROR : pause downloadFile file error.");
            }

            public void onNext(Integer integer) {
                LogUtil.d("Pause downloadFile file start.");
            }
        });
    }

    @Override
    public void resumeDownloadFile() {
        if (this.mCurFileInfo == null) {
            return;
        }
        this.mCurFileInfo.setFileState(3);
        ((ProxyRepository)this.proxyRepository.get()).resumeFileReceive(this.mCurFileInfo, new Subscriber<Integer>(){

            public void onCompleted() {
                LogUtil.d("Resume downloadFile file finished.");
            }

            public void onError(Throwable e) {
                LogUtil.d("ERROR : resume downloadFile file error.");
            }

            public void onNext(Integer integer) {
                LogUtil.d("Resume downloadFile file start.");
            }
        });
    }

    @Subscribe
    public void onReceiveFileFinished(IMProxyFileEvent.ReceiveFileFinishedEvent event) {
        long attachedMsgId = event.getAttachedMsgId();
        if (attachedMsgId <= -1L) {
            LogUtil.e("ERROR: Receive file finished event, msgId " + attachedMsgId);
            return;
        }
        if (this.mCurMessageBean.getId() == attachedMsgId) {
            this.mCurFileInfo.setFileState(2);
            ((FileDownloadVu)this.getVu()).downloadFileFinish();
        }
    }

    @Subscribe
    public void onReceiveFileUpdated(IMProxyFileEvent.ReceiveFileProgressUpdateEvent event) {
        long attachedMsgId = event.getAttachedMsgId();
        if (attachedMsgId <= -1L) {
            LogUtil.e("ERROR: Receive file update event, msgId " + attachedMsgId);
            return;
        }
        if (this.mCurMessageBean.getId() == attachedMsgId) {
            this.mCurFileInfo.setFileState(3);
            this.mCurFileInfo.setTranslateSize(event.getFileInfo().getTranslateSize());
            ((FileDownloadVu)this.getVu()).updateDownloadRate();
        }
    }

    @Subscribe
    public void onReceiveFilePaused(IMProxyFileEvent.ReceiveFilePausedEvent event) {
        long attachedMsgId = event.getAttachedMsgId();
        if (attachedMsgId <= -1L) {
            LogUtil.e("ERROR: Receive file pause event, msgId " + attachedMsgId);
            return;
        }
        if (this.mCurMessageBean.getId() == attachedMsgId) {
            this.mCurFileInfo.setFileState(4);
        }
    }

    @Subscribe
    public void onReceiveFileFailed(IMProxyFileEvent.ReceiveFileFailedEvent event) {
        long attachedMsgId = event.getAttachedMsgId();
        if (attachedMsgId <= -1L) {
            LogUtil.e("ERROR: Receive file pause event, msgId " + attachedMsgId);
            return;
        }
        if (this.mCurMessageBean.getId() == attachedMsgId) {
            this.mCurFileInfo.setFileState(5);
        }
    }

    @Override
    public void openFile() {
        if (this.mCurMessageBean == null) {
            return;
        }
        FileInfo fileInfo = this.mCurMessageBean.getFileInfo();
        File file = new File(fileInfo.getFilePath());
        if (!file.exists()) {
            CommonTool.showToast(R.string.im_uikit_file_not_exist);
        } else {
            SystemHelper.openFile((Activity)this, fileInfo.getFilePath());
        }
    }

    @Override
    public NormalFileInfo getCurFileInfo() {
        return this.mCurFileInfo;
    }

    public void onBackPressed() {
        Intent intent = new Intent();
        Bundle bundle = new Bundle();
        bundle.putLong("messageId", this.mCurMessageBean.getId());
        bundle.putInt("fileState", this.mCurFileInfo.getFileState());
        bundle.putLong("fileTranslateSize", this.mCurFileInfo.getTranslateSize());
        intent.putExtras(bundle);
        this.setResult(9, intent);
        this.finish();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        try {
            BusProvider.getInstance().unregister(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

