/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.adapter;

import android.app.Activity;
import com.xdja.im.base.frame.presenter.BaseItemAdapterPresenter;
import com.xdja.im.base.frame.view.AdapterBaseView;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.proxy.IMUiKitProxyImpl;
import com.xdja.im.uikit.ui.presenter.SessionListAdapterPresenter;
import com.xdja.im.uikit.ui.view.ViewCustomSessionItem;
import com.xdja.im.uikit.ui.view.ViewDefaultSessionItem;
import com.xdja.im.uikit.ui.view.ViewGroupItem;
import com.xdja.im.uikit.ui.view.ViewSingleItem;
import java.util.ArrayList;
import java.util.List;
import rx.Subscriber;

public class SessionListAdapter
extends BaseItemAdapterPresenter<SessionListAdapterPresenter, TalkSessionBean>
implements SessionListAdapterPresenter {
    private Activity mActivity;
    private final List<TalkSessionBean> mDataSource;
    private List<Class<? extends AdapterBaseView<SessionListAdapterPresenter, TalkSessionBean>>> vuClasses;

    public SessionListAdapter(Activity activity, List<TalkSessionBean> mDataSource) {
        this.mActivity = activity;
        this.mDataSource = mDataSource;
    }

    @Override
    protected Activity getActivity() {
        return this.mActivity;
    }

    @Override
    protected List<Class<? extends AdapterBaseView<SessionListAdapterPresenter, TalkSessionBean>>> getVuClasses() {
        if (this.vuClasses == null) {
            this.vuClasses = new ArrayList<Class<? extends AdapterBaseView<SessionListAdapterPresenter, TalkSessionBean>>>();
            this.vuClasses.add(ViewSingleItem.class);
            this.vuClasses.add(ViewGroupItem.class);
            this.vuClasses.add(ViewCustomSessionItem.class);
            this.vuClasses.add(ViewDefaultSessionItem.class);
        }
        return this.vuClasses;
    }

    public int getViewTypeCount() {
        return this.getVuClasses() != null ? this.getVuClasses().size() : 0;
    }

    public int getItemViewType(int position) {
        if (this.mDataSource != null) {
            int talkType = this.mDataSource.get(position).getTalkType();
            switch (talkType) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 999: {
                    return 2;
                }
            }
            return 3;
        }
        return 3;
    }

    @Override
    protected Class<? extends AdapterBaseView<SessionListAdapterPresenter, TalkSessionBean>> getVuClassByViewType(int itemViewType) {
        return this.getVuClasses().get(itemViewType);
    }

    @Override
    protected SessionListAdapterPresenter getPresenter() {
        return this;
    }

    @Override
    protected TalkSessionBean getDataSource(int position) {
        return this.mDataSource == null ? null : this.mDataSource.get(position);
    }

    public int getCount() {
        return this.mDataSource == null ? 0 : this.mDataSource.size();
    }

    public Object getItem(int position) {
        return this.mDataSource.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    @Override
    public void getAccount(String account, int talkType, Subscriber<AccountBean> subscriber) {
        IMUiKitProxyImpl.getInstance().getAccount(account, talkType, subscriber);
    }
}

