/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.graphics.drawable.AnimationDrawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.ui.view.BaseChatItem;
import com.xdja.im.uikit.view.BaseListDialog;

public class BaseReceiveItem
extends BaseChatItem {
    protected RelativeLayout mContentLayout;
    private ImageView mBombAnimImg;

    @Override
    protected void injectView() {
        super.injectView();
        this.mContentLayout = (RelativeLayout)this.findViewById(R.id.layout_message_container);
        this.mBombAnimImg = (ImageView)this.findViewById(R.id.img_bomb_anim);
        this.mContentLayout.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                BaseReceiveItem.this.mPopDialog.addData(BaseReceiveItem.this.getPopItemData());
                BaseReceiveItem.this.mPopDialog.show(BaseReceiveItem.this.curPosition);
                return true;
            }
        });
        this.mPopDialog.setOnItemClickListener(new BaseListDialog.onItemClickListener(){

            @Override
            public void onItemClick(View view, int position, int itemPosition) {
                BaseReceiveItem.this.mPopDialog.dismiss();
                switch (position) {
                    case 0: {
                        ((ChatListAdapterPresenter)BaseReceiveItem.this.getPresenter()).deleteItem(itemPosition);
                        break;
                    }
                    case 1: {
                        ((ChatListAdapterPresenter)BaseReceiveItem.this.getPresenter()).copyMessage(itemPosition);
                    }
                }
            }
        });
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
    }

    protected void setContentLayoutBackground(@DrawableRes int resId) {
        this.mContentLayout.setBackgroundResource(resId);
    }

    protected void startBombAnim() {
        if (this.mBombAnimImg != null) {
            AnimationDrawable boomAnim = (AnimationDrawable)this.mBombAnimImg.getBackground();
            boomAnim.stop();
            boomAnim.start();
        }
    }

    protected void setMessageDestroy(boolean isDestroy) {
        if (((TalkMessageBean)this.dataSource).getMessageType() == 3 || ((TalkMessageBean)this.dataSource).getMessageType() == 2) {
            return;
        }
        if (this.mContentLayout != null) {
            if (isDestroy) {
                this.mContentLayout.setBackgroundResource(R.drawable.im_uikit_bg_receive_shan_selector);
            } else {
                this.mContentLayout.setBackgroundResource(R.drawable.im_uikit_bg_receive_selector);
            }
        }
    }

    protected void setDestroyView(TextView destroyView, boolean isDestroy, String destroyStr) {
        if (destroyView != null) {
            if (isDestroy) {
                destroyView.setVisibility(0);
                destroyView.setTextColor(this.getLimitTextColor());
                destroyView.setText((CharSequence)destroyStr);
            } else {
                destroyView.setVisibility(8);
            }
        }
    }

    protected void showPopDialog() {
        this.mPopDialog.addData(this.getPopItemData());
        this.mPopDialog.show(this.curPosition);
    }

    protected void dismissPopDialog() {
        if (this.mPopDialog != null) {
            this.mPopDialog.dismiss();
        }
    }
}

