/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.presenter.ChatListAdapterPresenter;
import com.xdja.im.uikit.ui.view.BaseReceiveItem;
import com.xdja.im.uikit.utils.file.FileUtils;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.view.ChatImageView;

public class ViewRecvImageItem
extends BaseReceiveItem {
    private ChatImageView mChatImage;
    private ImageView mBombFlagImg;
    private ProgressBar mLoadingPbar;
    private ImageButton mRetryBtn;

    @Override
    protected int getLayoutRes() {
        return R.layout.im_uikit_item_chat_receive_image;
    }

    @Override
    protected void injectView() {
        super.injectView();
        this.mChatImage = (ChatImageView)this.findViewById(R.id.img_receive_image);
        this.mBombFlagImg = (ImageView)this.findViewById(R.id.img_bomb_flag);
        this.mLoadingPbar = (ProgressBar)this.findViewById(R.id.pbar_loading);
        this.mRetryBtn = (ImageButton)this.findViewById(R.id.img_retry_download);
        this.mContentLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ((ChatListAdapterPresenter)ViewRecvImageItem.this.getPresenter()).previewImage((TalkMessageBean)ViewRecvImageItem.this.dataSource);
            }
        });
        this.mRetryBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ViewRecvImageItem.this.mLoadingPbar.setVisibility(0);
                ViewRecvImageItem.this.mChatImage.setImageBitmap(null);
                ViewRecvImageItem.this.mRetryBtn.setVisibility(8);
                ((ChatListAdapterPresenter)ViewRecvImageItem.this.getPresenter()).downLoadFile(((TalkMessageBean)ViewRecvImageItem.this.dataSource).getFileInfo());
            }
        });
    }

    @Override
    public void onViewReused() {
        super.onViewReused();
        this.mChatImage.setImageBitmap(null);
        this.mContentLayout.setBackgroundResource(0);
        this.mLoadingPbar.setVisibility(8);
        this.mRetryBtn.setVisibility(8);
    }

    @Override
    public void bindDataSource(int position, TalkMessageBean dataSource) {
        super.bindDataSource(position, dataSource);
        FileInfo fileInfo = dataSource.getFileInfo();
        if (fileInfo == null) {
            LogUtil.e("load image, but file info is null");
            this.mChatImage.setImageResource(R.mipmap.im_uikit_pic_failed);
            return;
        }
        if (dataSource.getMessageState() == 5) {
            this.mBombFlagImg.setVisibility(8);
            this.mChatImage.setImageResource(R.mipmap.im_uikit_bg_shanxin_image);
        } else {
            this.mBombFlagImg.setVisibility(8);
            if (TextUtils.isEmpty((CharSequence)fileInfo.getFilePath())) {
                this.setReDownloadVisible();
                return;
            }
            if (fileInfo.getFileState() == 5) {
                this.setProgressBarVisible(false);
                this.setReDownloadVisible();
            } else if (fileInfo.getFileState() == 2) {
                this.setProgressBarVisible(false);
                this.loadImage(fileInfo.getFilePath());
            } else {
                this.mChatImage.setImageResource(R.drawable.im_uikit_bg_pbar_loading);
                this.setProgressBarVisible(true);
                ((ChatListAdapterPresenter)this.getPresenter()).downLoadFile(fileInfo);
            }
            if (dataSource.getMessageState() < 4) {
                ((ChatListAdapterPresenter)this.getPresenter()).sendReadReceipt(dataSource);
            }
            if (dataSource.getMessageState() == 6) {
                this.startBombAnim();
                final TalkMessageBean cloneSource = new TalkMessageBean(dataSource);
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ((ChatListAdapterPresenter)ViewRecvImageItem.this.getPresenter()).postDestroyAnimate(cloneSource);
                        ViewRecvImageItem.this.loadImageResource(R.mipmap.im_uikit_bg_shanxin_image);
                    }
                }, 700L);
            }
        }
    }

    private void setReDownloadVisible() {
        this.loadImageResource(R.mipmap.im_uikit_pic_failed);
        if (this.mRetryBtn == null) {
            LogUtil.w("ERROR:reDownloadImageBtn is null.");
            return;
        }
        this.mRetryBtn.setVisibility(0);
    }

    private void loadImageResource(int srcId) {
        this.mChatImage.setImageResource(srcId);
        this.mLoadingPbar.setVisibility(8);
        this.mBombFlagImg.setVisibility(8);
        this.setMessageDestroy(((TalkMessageBean)this.dataSource).isBomb());
    }

    private void loadImage(String filePath) {
        if (FileUtils.isFileExists(filePath)) {
            this.mChatImage.loadImage(filePath);
            if (this.mContentLayout.getVisibility() == 0) {
                ((ChatListAdapterPresenter)this.getPresenter()).scrollTo(this.curPosition);
            }
        } else {
            this.mChatImage.setError(R.mipmap.im_uikit_pic_default);
        }
    }

    private void setProgressBarVisible(boolean isVisible) {
        if (isVisible) {
            this.mLoadingPbar.setVisibility(0);
        } else {
            this.mLoadingPbar.setVisibility(8);
        }
    }
}

