/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.ui.view;

import android.app.Activity;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.text.Html;
import android.text.TextPaint;
import android.text.TextUtils;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.xdja.im.base.frame.view.AdapterBaseView;
import com.xdja.im.base.frame.view.AdapterSuperBaseView;
import com.xdja.im.common.imageloader.GlideCircleTransform;
import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.uikit.R;
import com.xdja.im.uikit.ui.presenter.SessionListAdapterPresenter;
import com.xdja.im.uikit.utils.log.LogUtil;
import com.xdja.im.uikit.utils.sys.TimeUtil;
import rx.Subscriber;

public class ViewSessionItem
extends AdapterSuperBaseView<SessionListAdapterPresenter, TalkSessionBean>
implements AdapterBaseView<SessionListAdapterPresenter, TalkSessionBean> {
    private LinearLayout mLayout;
    private ImageView mUserHeader;
    private TextView mUnReadCountTv;
    private ImageView mNewMsgFlagImg;
    private TextView mUserNameTv;
    private TextView mContentTv;
    private ImageView mMessageStateImg;
    private TextView mDisplayTimeTv;
    private ImageView mDisturbFlag;

    @Override
    protected void injectView() {
        super.injectView();
        this.mLayout = (LinearLayout)this.findViewById(R.id.layout_session_item);
        this.mUserHeader = (ImageView)this.findViewById(R.id.img_user_header);
        this.mUnReadCountTv = (TextView)this.findViewById(R.id.tv_unread_message);
        this.mNewMsgFlagImg = (ImageView)this.findViewById(R.id.img_new_message_flag);
        this.mUserNameTv = (TextView)this.findViewById(R.id.tv_user_name);
        this.mContentTv = (TextView)this.findViewById(R.id.tv_content);
        this.mMessageStateImg = (ImageView)this.findViewById(R.id.img_message_state);
        this.mDisplayTimeTv = (TextView)this.findViewById(R.id.tv_display_time);
        this.mDisturbFlag = (ImageView)this.findViewById(R.id.img_disturb_flag);
    }

    @Override
    public void bindDataSource(int position, @NonNull TalkSessionBean dataSource) {
        super.bindDataSource(position, dataSource);
        if (dataSource == null) {
            LogUtil.e("dataSource is null.");
            return;
        }
        this.updateContentData();
        this.updateUnreadCount();
        this.updateMessageState();
        this.updateSessionParam();
    }

    private void updateSessionParam() {
        if (((TalkSessionBean)this.dataSource).getParam() != null) {
            if (((TalkSessionBean)this.dataSource).getParam().isTop()) {
                this.mLayout.setBackgroundResource(R.drawable.im_uikit_bg_session_item_top);
            } else {
                this.mLayout.setBackgroundResource(R.drawable.im_uikit_bg_session_item_normal);
            }
            if (((TalkSessionBean)this.dataSource).getParam().isDisturb()) {
                this.mDisturbFlag.setVisibility(0);
            } else {
                this.mDisturbFlag.setVisibility(8);
            }
        } else {
            this.mDisturbFlag.setVisibility(8);
            this.mLayout.setBackgroundResource(R.drawable.im_uikit_bg_session_item_normal);
        }
    }

    private void updateContentData() {
        this.mContentTv.setText(this.ellipsize(this.getContent()));
        this.mDisplayTimeTv.setText((CharSequence)this.getDisplayTime());
        final String account = ((TalkSessionBean)this.dataSource).getTalkerAccount();
        if (TextUtils.isEmpty((CharSequence)account)) {
            LogUtil.e("ERROR: User account is null.");
            return;
        }
        ((SessionListAdapterPresenter)this.getPresenter()).getAccount(account, ((TalkSessionBean)this.dataSource).getTalkType(), new Subscriber<AccountBean>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                ViewSessionItem.this.mUserNameTv.setText((CharSequence)account);
            }

            public void onNext(AccountBean accountBean) {
                if (accountBean == null) {
                    ViewSessionItem.this.mUserNameTv.setText((CharSequence)account);
                    return;
                }
                if (((TalkSessionBean)ViewSessionItem.this.dataSource).getTalkType() != 2) {
                    if (!TextUtils.isEmpty((CharSequence)accountBean.getDisplayName())) {
                        ViewSessionItem.this.mUserNameTv.setText((CharSequence)accountBean.getDisplayName());
                    } else {
                        ViewSessionItem.this.mUserNameTv.setText((CharSequence)account);
                    }
                }
                Glide.with((Activity)ViewSessionItem.this.getActivity()).load(accountBean.getAvatarUrl()).placeholder(R.mipmap.im_uikit_user_header_40dp).error(R.mipmap.im_uikit_user_header_40dp).bitmapTransform(new Transformation[]{new GlideCircleTransform(ViewSessionItem.this.getContext())}).into(ViewSessionItem.this.mUserHeader);
            }
        });
    }

    private void updateMessageState() {
        TalkMessageBean talkMessageBean = ((TalkSessionBean)this.dataSource).getLastMsg();
        if (talkMessageBean == null) {
            LogUtil.w("session last message is null.");
            return;
        }
        this.mMessageStateImg.setVisibility(8);
        if (talkMessageBean.getMessageType() == 101) {
            return;
        }
        if (talkMessageBean.getFrom() == null || talkMessageBean.getTo() == null) {
            return;
        }
        SessionParam param = ((TalkSessionBean)this.dataSource).getParam();
        if (param != null && !TextUtils.isEmpty((CharSequence)param.getDraftContent()) && param.getDraftTime() > 0L) {
            return;
        }
        if (talkMessageBean.getMessageState() == 1) {
            this.mMessageStateImg.setVisibility(0);
            this.mMessageStateImg.setImageResource(R.mipmap.im_uikit_ic_message_state_sending);
        } else if (talkMessageBean.getMessageState() == 0) {
            this.mMessageStateImg.setVisibility(0);
            this.mMessageStateImg.setImageResource(R.mipmap.im_uikit_ic_message_state_fail);
        }
    }

    private void updateUnreadCount() {
        int notReadCount = ((TalkSessionBean)this.dataSource).getNotReadCount();
        if (notReadCount > 0) {
            this.setNotReadShow(true);
            SessionParam param = ((TalkSessionBean)this.dataSource).getParam();
            if (param != null && param.isDisturb()) {
                this.mUnReadCountTv.setVisibility(8);
                this.mNewMsgFlagImg.setVisibility(0);
                return;
            }
            if (notReadCount > 99) {
                this.setNotReadCount((CharSequence)Html.fromHtml((String)"<b>...</b>"));
            } else {
                this.setNotReadCount(notReadCount + "");
            }
        } else {
            this.setNotReadShow(false);
        }
    }

    private void setNotReadShow(boolean isShow) {
        if (isShow) {
            this.mUnReadCountTv.setVisibility(0);
        } else {
            this.mUnReadCountTv.setVisibility(8);
        }
        this.mNewMsgFlagImg.setVisibility(8);
    }

    private void setNotReadCount(CharSequence countText) {
        this.mUnReadCountTv.setText(countText);
    }

    private void setTextColor(@ColorRes int idRes) {
        this.mContentTv.setTextColor(this.getColorRes(idRes));
    }

    protected String getUserName() {
        return ((TalkSessionBean)this.dataSource).getLastMsgAccount();
    }

    protected CharSequence getContent() {
        return "";
    }

    protected String getDisplayTime() {
        if (((TalkSessionBean)this.dataSource).getLastTime() > 0L) {
            return TimeUtil.convertSessionTime(((TalkSessionBean)this.dataSource).getLastTime());
        }
        return "";
    }

    public void setTimeVisibility(int visibility) {
        this.mDisplayTimeTv.setVisibility(visibility);
    }

    protected CharSequence formatDraft(String content) {
        String draftPreStr = "<font color=\"#941100\">" + this.getStringRes(R.string.im_uikit_draft) + "</font>";
        return Html.fromHtml((String)(draftPreStr + content));
    }

    protected CharSequence ellipsize(CharSequence content) {
        return TextUtils.ellipsize((CharSequence)content, (TextPaint)this.mContentTv.getPaint(), (float)(this.mContentTv.getMaxWidth() - 8), (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
    }
}

