/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.utils.audio;

import android.text.TextUtils;
import com.xdja.im.core.model.message.file.FileInfo;
import com.xdja.im.lib.audio.player.AudioPlayerManager;
import com.xdja.im.uikit.utils.log.LogUtil;

public class AudioPlayerManagerProxy {
    public static void startToPlay(FileInfo fileInfo, long messageId, boolean isNext) {
        AudioPlayerManagerProxy.preStartPlay(fileInfo, messageId);
        if (fileInfo != null) {
            AudioPlayerManagerProxy.getManager().startToPlay(fileInfo.getFilePath(), messageId, isNext);
        }
    }

    public static void preStartPlay(FileInfo fileInfo, long messageId) {
        if (AudioPlayerManagerProxy.isPlaying()) {
            AudioPlayerManagerProxy.stopPlay();
        }
    }

    public static synchronized boolean isPlayingWithMessage(FileInfo fileInfo) {
        String currentPath = AudioPlayerManagerProxy.getManager().getCurrentPlayPath();
        Object[] args = AudioPlayerManagerProxy.getManager().getArgs();
        LogUtil.d("Player isPlayingWithMessage currPath=" + (currentPath == null ? "null" : currentPath) + ",filPath" + fileInfo.getFilePath());
        if (args == null || args != null && args.length == 0 || TextUtils.isEmpty((CharSequence)currentPath) || fileInfo == null || fileInfo != null && TextUtils.isEmpty((CharSequence)fileInfo.getFilePath())) {
            return false;
        }
        long msgId = (Long)args[0];
        return fileInfo.getFilePath().equals(currentPath) && fileInfo.getTalkMessageId() == msgId;
    }

    public static void release() {
        AudioPlayerManagerProxy.getManager().releasePlayer();
    }

    private static AudioPlayerManager getManager() {
        return AudioPlayerManager.getInstance();
    }

    public static void stopPlay() {
        AudioPlayerManagerProxy.getManager().stopPlay();
    }

    public static boolean isPlaying() {
        return AudioPlayerManagerProxy.getManager().isPlaying();
    }
}

