/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.utils.log.klog;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Random;

public class FileLog {
    private static final String FILE_PREFIX = "KLog_";
    private static final String FILE_FORMAT = ".log";

    public static void printFile(String tag, File targetDirectory, @Nullable String fileName, String headString, String msg) {
        String string2 = fileName = fileName == null ? FileLog.getFileName() : fileName;
        if (FileLog.save(targetDirectory, fileName, msg)) {
            Log.d((String)tag, (String)(headString + " save log success ! location is >>>" + targetDirectory.getAbsolutePath() + "/" + fileName));
        } else {
            Log.e((String)tag, (String)(headString + "save log fails !"));
        }
    }

    private static boolean save(File dic, @NonNull String fileName, String msg) {
        File file = new File(dic, fileName);
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
            outputStreamWriter.write(msg);
            outputStreamWriter.flush();
            ((OutputStream)outputStream).close();
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static String getFileName() {
        Random random = new Random();
        return FILE_PREFIX + Long.toString(System.currentTimeMillis() + (long)random.nextInt(10000)).substring(4) + FILE_FORMAT;
    }
}

