/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.view;

import android.app.Dialog;
import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SimpleAdapter;
import com.xdja.im.uikit.R;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseListDialog
extends Dialog {
    public static final String PARAM_ITEM = "item";
    private ListView mListView;
    private SimpleAdapter mAdapter;
    private List<Map<String, String>> mDatas = new ArrayList<Map<String, String>>();
    private onItemClickListener onItemClickListener;
    private int mItemPosition;

    public void setOnItemClickListener(onItemClickListener listener) {
        this.onItemClickListener = listener;
    }

    public BaseListDialog(@NonNull Context context) {
        super(context, R.style.im_uikit_BaseDialogStyle);
        this.setContentView(R.layout.im_uikit_dialg_option_list);
        this.setCancelable(true);
        this.initView();
    }

    private void initView() {
        this.mListView = (ListView)this.findViewById(R.id.lv_options);
        this.mAdapter = new SimpleAdapter(this.getContext(), this.mDatas, R.layout.im_uikit_item_dialog_option, new String[]{PARAM_ITEM}, new int[]{R.id.tv_option});
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (BaseListDialog.this.onItemClickListener != null) {
                    BaseListDialog.this.onItemClickListener.onItemClick(view, position, BaseListDialog.this.mItemPosition);
                }
            }
        });
        this.addData(this.getOptions());
    }

    public void addData(CharSequence[] options) {
        if (options == null || options.length == 0) {
            return;
        }
        this.mDatas.clear();
        for (int i = 0; i < options.length; ++i) {
            HashMap<String, String> listItem = new HashMap<String, String>();
            listItem.put(PARAM_ITEM, options[i].toString());
            this.mDatas.add(listItem);
        }
        this.mAdapter.notifyDataSetChanged();
    }

    public void show(int position) {
        super.show();
        this.mItemPosition = position;
    }

    public abstract CharSequence[] getOptions();

    public static interface onItemClickListener {
        public void onItemClick(View var1, int var2, int var3);
    }
}

