/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.im.uikit.view;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowInsets;
import android.widget.LinearLayout;

public class KeyboardLayout
extends LinearLayout {
    private Activity mActivity;
    private int[] mInsets = new int[4];

    public KeyboardLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public KeyboardLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public KeyboardLayout(Context context) {
        super(context);
    }

    public void setActivity(Activity activity) {
        this.mActivity = activity;
    }

    public float getSupportSoftInputHeight() {
        if (this.mActivity == null) {
            return -1.0f;
        }
        Rect r = new Rect();
        View decorView = this.mActivity.getWindow().getDecorView();
        decorView.getWindowVisibleDisplayFrame(r);
        float screenHeight = decorView.getRootView().getHeight();
        float softInputHeight = screenHeight - (float)r.bottom;
        if (Build.VERSION.SDK_INT >= 20) {
            int bottomHeight = this.getBottomButtonWidth();
            softInputHeight -= (float)bottomHeight;
        }
        return softInputHeight;
    }

    private int getBottomButtonWidth() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.mActivity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        int unRealHeight = displayMetrics.heightPixels;
        this.mActivity.getWindowManager().getDefaultDisplay().getRealMetrics(displayMetrics);
        int realHeight = displayMetrics.heightPixels;
        if (unRealHeight < realHeight) {
            return realHeight - unRealHeight;
        }
        return 0;
    }

    public boolean isSoftInputShown() {
        float height = this.getSupportSoftInputHeight();
        return height > 0.0f;
    }

    public WindowInsets computeSystemWindowInsets(WindowInsets in, Rect outLocalInsets) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.mInsets[0] = outLocalInsets.left;
            this.mInsets[1] = outLocalInsets.top;
            this.mInsets[2] = outLocalInsets.right;
            outLocalInsets.left = 0;
            outLocalInsets.top = 0;
            outLocalInsets.right = 0;
        }
        return super.computeSystemWindowInsets(in, outLocalInsets);
    }

    public WindowInsets onApplyWindowInsets(WindowInsets insets) {
        if (Build.VERSION.SDK_INT >= 20) {
            this.mInsets[0] = insets.getSystemWindowInsetLeft();
            this.mInsets[1] = insets.getSystemWindowInsetTop();
            this.mInsets[2] = insets.getSystemWindowInsetRight();
            return super.onApplyWindowInsets(insets.replaceSystemWindowInsets(0, 0, 0, insets.getSystemWindowInsetBottom()));
        }
        return insets;
    }
}

