/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.http.impl.client;

import com.xdja.http.HttpEntity;
import com.xdja.http.HttpResponse;
import com.xdja.http.StatusLine;
import com.xdja.http.annotation.Immutable;
import com.xdja.http.client.HttpResponseException;
import com.xdja.http.client.ResponseHandler;
import com.xdja.http.util.EntityUtils;
import java.io.IOException;

@Immutable
public abstract class AbstractResponseHandler<T>
implements ResponseHandler<T> {
    @Override
    public T handleResponse(HttpResponse response) throws HttpResponseException, IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            EntityUtils.consume(entity);
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return entity == null ? null : (T)this.handleEntity(entity);
    }

    public abstract T handleEntity(HttpEntity var1) throws IOException;
}

