/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.http.impl.conn;

import com.xdja.http.HttpException;
import com.xdja.http.HttpHost;
import com.xdja.http.HttpRequest;
import com.xdja.http.ProtocolException;
import com.xdja.http.annotation.Immutable;
import com.xdja.http.client.config.RequestConfig;
import com.xdja.http.client.protocol.HttpClientContext;
import com.xdja.http.conn.SchemePortResolver;
import com.xdja.http.conn.UnsupportedSchemeException;
import com.xdja.http.conn.routing.HttpRoute;
import com.xdja.http.conn.routing.HttpRoutePlanner;
import com.xdja.http.impl.conn.DefaultSchemePortResolver;
import com.xdja.http.protocol.HttpContext;
import com.xdja.http.util.Args;
import java.net.InetAddress;

@Immutable
public class DefaultRoutePlanner
implements HttpRoutePlanner {
    private final SchemePortResolver schemePortResolver;

    public DefaultRoutePlanner(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    @Override
    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        HttpHost target;
        Args.notNull(request, "Request");
        if (host == null) {
            throw new ProtocolException("Target host is not specified");
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig config = clientContext.getRequestConfig();
        InetAddress local = config.getLocalAddress();
        HttpHost proxy = config.getProxy();
        if (proxy == null) {
            proxy = this.determineProxy(host, request, context);
        }
        if (host.getPort() <= 0) {
            try {
                target = new HttpHost(host.getHostName(), this.schemePortResolver.resolve(host), host.getSchemeName());
            }
            catch (UnsupportedSchemeException ex) {
                throw new HttpException(ex.getMessage());
            }
        } else {
            target = host;
        }
        boolean secure = target.getSchemeName().equalsIgnoreCase("https");
        if (proxy == null) {
            return new HttpRoute(target, local, secure);
        }
        return new HttpRoute(target, local, proxy, secure);
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        return null;
    }
}

