/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.http.impl.cookie;

import com.xdja.http.annotation.Immutable;
import com.xdja.http.client.utils.DateUtils;
import com.xdja.http.cookie.CommonCookieAttributeHandler;
import com.xdja.http.cookie.MalformedCookieException;
import com.xdja.http.cookie.SetCookie;
import com.xdja.http.impl.cookie.AbstractCookieAttributeHandler;
import com.xdja.http.util.Args;
import java.util.Date;

@Immutable
public class BasicExpiresHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    private final String[] datepatterns;

    public BasicExpiresHandler(String[] datepatterns) {
        Args.notNull(datepatterns, "Array of date patterns");
        this.datepatterns = datepatterns;
    }

    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for 'expires' attribute");
        }
        Date expiry = DateUtils.parseDate(value, this.datepatterns);
        if (expiry == null) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + value);
        }
        cookie.setExpiryDate(expiry);
    }

    @Override
    public String getAttributeName() {
        return "expires";
    }
}

