/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.http.impl.cookie;

import com.xdja.http.annotation.Immutable;
import com.xdja.http.cookie.CommonCookieAttributeHandler;
import com.xdja.http.cookie.Cookie;
import com.xdja.http.cookie.CookieOrigin;
import com.xdja.http.cookie.CookieRestrictionViolationException;
import com.xdja.http.cookie.MalformedCookieException;
import com.xdja.http.cookie.SetCookie;
import com.xdja.http.impl.cookie.AbstractCookieAttributeHandler;
import com.xdja.http.util.Args;

@Immutable
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value.trim().isEmpty()) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            cookie.setVersion(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid version: " + e.getMessage());
        }
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

