/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.http.impl.entity;

import com.xdja.http.HttpException;
import com.xdja.http.HttpMessage;
import com.xdja.http.ProtocolException;
import com.xdja.http.annotation.Immutable;
import com.xdja.http.entity.ContentLengthStrategy;
import com.xdja.http.impl.entity.LaxContentLengthStrategy;

@Immutable
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    public static final DisallowIdentityContentLengthStrategy INSTANCE = new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

