/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.http.message;

import com.xdja.http.HttpRequest;
import com.xdja.http.HttpVersion;
import com.xdja.http.ProtocolVersion;
import com.xdja.http.RequestLine;
import com.xdja.http.annotation.NotThreadSafe;
import com.xdja.http.message.AbstractHttpMessage;
import com.xdja.http.message.BasicRequestLine;
import com.xdja.http.util.Args;

@NotThreadSafe
public class BasicHttpRequest
extends AbstractHttpMessage
implements HttpRequest {
    private final String method;
    private final String uri;
    private RequestLine requestline;

    public BasicHttpRequest(String method, String uri) {
        this.method = Args.notNull(method, "Method name");
        this.uri = Args.notNull(uri, "Request URI");
        this.requestline = null;
    }

    public BasicHttpRequest(String method, String uri, ProtocolVersion ver) {
        this(new BasicRequestLine(method, uri, ver));
    }

    public BasicHttpRequest(RequestLine requestline) {
        this.requestline = Args.notNull(requestline, "Request line");
        this.method = requestline.getMethod();
        this.uri = requestline.getUri();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.getRequestLine().getProtocolVersion();
    }

    @Override
    public RequestLine getRequestLine() {
        if (this.requestline == null) {
            this.requestline = new BasicRequestLine(this.method, this.uri, HttpVersion.HTTP_1_1);
        }
        return this.requestline;
    }

    public String toString() {
        return this.method + ' ' + this.uri + ' ' + this.headergroup;
    }
}

