/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.http.protocol;

import com.xdja.http.HttpEntity;
import com.xdja.http.HttpEntityEnclosingRequest;
import com.xdja.http.HttpException;
import com.xdja.http.HttpRequest;
import com.xdja.http.HttpRequestInterceptor;
import com.xdja.http.HttpVersion;
import com.xdja.http.ProtocolVersion;
import com.xdja.http.annotation.Immutable;
import com.xdja.http.protocol.HttpContext;
import com.xdja.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

