/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.http.protocol;

import com.xdja.http.HttpConnection;
import com.xdja.http.HttpException;
import com.xdja.http.HttpHost;
import com.xdja.http.HttpInetConnection;
import com.xdja.http.HttpRequest;
import com.xdja.http.HttpRequestInterceptor;
import com.xdja.http.HttpVersion;
import com.xdja.http.ProtocolException;
import com.xdja.http.ProtocolVersion;
import com.xdja.http.annotation.Immutable;
import com.xdja.http.protocol.HttpContext;
import com.xdja.http.protocol.HttpCoreContext;
import com.xdja.http.util.Args;
import java.io.IOException;
import java.net.InetAddress;

@Immutable
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext corecontext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targethost = corecontext.getTargetHost();
            if (targethost == null) {
                HttpConnection conn = corecontext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targethost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targethost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targethost.toHostString());
        }
    }
}

