/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.IBinder;
import android.text.TextUtils;
import com.xdja.imsdk.logger.Logger;
import com.xdja.imsdk.manager.ImSdkManager;
import com.xdja.imsdk.manager.ImSyncManager;
import com.xdja.imsdk.model.InitParam;
import com.xdja.imsdk.receiver.NetworkStatusReceiver;
import com.xdja.imsdk.util.ToolUtils;
import java.util.concurrent.atomic.AtomicBoolean;

public class ImSdkService
extends Service {
    private Thread initThread;
    private NetworkStatusReceiver networkStatusReceiver;
    private AtomicBoolean initIsDone;
    private static InitParam initParam;
    private String cardId;
    private String topic;

    public void onCreate() {
        super.onCreate();
        Logger.getLogger().i("onCreate ...");
        this.initIsDone = new AtomicBoolean(false);
        this.registerBroadcastReceiver();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent == null) {
            return 2;
        }
        if ("im.action.init".equals(intent.getAction()) && (initParam = (InitParam)intent.getParcelableExtra("im.init.param")) != null) {
            this.cardId = initParam.getTfcardId();
            this.topic = this.getPushTopic();
            this.startInitImSdk();
            return 2;
        }
        if (this.getInitState() && "im.action.state".equals(intent.getAction())) {
            String state = intent.getStringExtra("im.state.param");
            Logger.getLogger().d("ImSdk receive push state [" + state + "]");
            ImSyncManager.getInstance().handlePushConnectResult(ToolUtils.getInt(state));
            return 2;
        }
        if (this.getInitState() && "im.action.topic".equals(intent.getAction())) {
            String receiveTopic = intent.getStringExtra("im.topic.param");
            Logger.getLogger().d("ImSdk receive push new message [" + receiveTopic + "]");
            if (!TextUtils.equals((CharSequence)this.topic, (CharSequence)receiveTopic)) {
                Logger.getLogger().d("ImSdk receive push topic diff!!! [" + this.topic + "]");
                return 2;
            }
            ImSyncManager.getInstance().handlePushNewNotice();
        }
        return 2;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onDestroy() {
        Logger.getLogger().i("onDestroy " + this.getInitState() + "...");
        this.unregisterReceiver(this.networkStatusReceiver);
        this.stopInitThread();
        this.setInitIsDone(false);
        ImSdkManager.getInstance().releaseAll();
    }

    private void startInitImSdk() {
        if (initParam != null) {
            this.cardId = initParam.getTfcardId();
            try {
                if (this.initThread == null) {
                    this.initThread = new Thread(new InitSdkRunnable());
                    this.initThread.setName("InitThread");
                    this.initThread.start();
                } else if (!this.initThread.isAlive()) {
                    this.initThread.start();
                }
            }
            catch (Exception e) {
                Logger.getLogger().d("Im init exception...");
                this.initThread = null;
            }
        }
    }

    private void registerBroadcastReceiver() {
        if (this.networkStatusReceiver != null) {
            return;
        }
        this.networkStatusReceiver = new NetworkStatusReceiver();
        IntentFilter filter = new IntentFilter("com.xdja.npcs.PUSHSTATE");
        this.registerReceiver(this.networkStatusReceiver, filter);
    }

    private String getPushTopic() {
        String topic;
        if (initParam != null && initParam.getProperties() != null && !TextUtils.isEmpty((CharSequence)(topic = initParam.getProperties().get("push_topic")))) {
            return topic;
        }
        return "xdja/d/" + this.cardId + "/im";
    }

    private boolean getInitState() {
        return this.initIsDone != null && this.initIsDone.get();
    }

    private void setInitIsDone(boolean done) {
        if (this.initIsDone != null) {
            this.initIsDone.set(done);
        }
    }

    private void stopInitThread() {
        if (this.initThread != null && this.initThread.isAlive() && !this.getInitState()) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                Logger.getLogger().e("Im init fail");
                this.initThread = null;
            }
            try {
                this.initThread.interrupt();
            }
            catch (Exception e) {
                Logger.getLogger().e("Im init fail");
                this.initThread = null;
            }
        }
        this.initThread = null;
    }

    protected class InitSdkRunnable
    implements Runnable {
        protected InitSdkRunnable() {
        }

        @Override
        public void run() {
            try {
                try {
                    ImSdkManager.getInstance().init((Context)ImSdkService.this, initParam);
                }
                catch (Exception e) {
                    Logger.getLogger().d("Im init fail");
                    ImSdkService.this.setInitIsDone(true);
                }
            }
            finally {
                ImSdkService.this.setInitIsDone(true);
            }
        }
    }
}

