/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.db;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.xdja.imsdk.db.ImSdkContext;
import com.xdja.imsdk.db.ImSdkDatabaseHelper;
import com.xdja.imsdk.logger.Logger;

public class DbHelper {
    private static final String DATABASE_NAME = "imsdk.db";
    private static DbHelper dbHelper;
    private ImSdkDatabaseHelper imSdkDatabaseHelper;
    private SQLiteDatabase sqLiteDatabase;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DbHelper getInstance() {
        if (dbHelper != null) return dbHelper;
        Class<DbHelper> clazz = DbHelper.class;
        synchronized (DbHelper.class) {
            if (dbHelper != null) return dbHelper;
            dbHelper = new DbHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return dbHelper;
        }
    }

    private DbHelper() {
    }

    public void initDatabase(Context context, String account) {
        if (context == null || TextUtils.isEmpty((CharSequence)account)) {
            throw new RuntimeException("database init exception...");
        }
        Logger.getLogger().i("init database...");
        this.imSdkDatabaseHelper = new ImSdkDatabaseHelper((Context)new ImSdkContext(context, account), DATABASE_NAME, account);
    }

    public synchronized SQLiteDatabase getDatabase() {
        if (this.imSdkDatabaseHelper == null) {
            throw new RuntimeException("database already closed...");
        }
        if (this.sqLiteDatabase == null) {
            this.sqLiteDatabase = this.imSdkDatabaseHelper.getReadableDatabase();
        }
        return this.sqLiteDatabase;
    }

    public synchronized void close() {
        Logger.getLogger().i("close database...");
        if (dbHelper != null && this.imSdkDatabaseHelper != null) {
            this.imSdkDatabaseHelper.close();
        }
        this.imSdkDatabaseHelper = null;
        dbHelper = null;
    }
}

