/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.db;

import android.content.ContentValues;
import com.xdja.imsdk.constant.ImSdkFileConstant;
import com.xdja.imsdk.db.bean.DuplicateIdDb;
import com.xdja.imsdk.db.bean.LocalStateMsgDb;
import com.xdja.imsdk.db.bean.OptionsDb;
import com.xdja.imsdk.db.bean.SyncIdDb;
import com.xdja.imsdk.db.builder.FileMsgBuilder;
import com.xdja.imsdk.db.builder.HdThumbFileBuilder;
import com.xdja.imsdk.db.builder.LocalStateMsgBuilder;
import com.xdja.imsdk.db.builder.MsgEntryBuilder;
import com.xdja.imsdk.db.builder.RawFileBuilder;
import com.xdja.imsdk.db.builder.SessionEntryBuilder;
import com.xdja.imsdk.db.dao.DeletedMsgDao;
import com.xdja.imsdk.db.dao.FileMsgDao;
import com.xdja.imsdk.db.dao.HdThumbFileDao;
import com.xdja.imsdk.db.dao.LocalStateMsgDao;
import com.xdja.imsdk.db.dao.MsgEntryDao;
import com.xdja.imsdk.db.dao.OptionsDao;
import com.xdja.imsdk.db.dao.RawFileDao;
import com.xdja.imsdk.db.dao.SessionEntryDao;
import com.xdja.imsdk.db.dao.SyncIdDao;
import com.xdja.imsdk.db.helper.DelArgs;
import com.xdja.imsdk.db.helper.OptType;
import com.xdja.imsdk.db.helper.UpdateArgs;
import com.xdja.imsdk.db.wrapper.MessageWrapper;
import com.xdja.imsdk.db.wrapper.SessionWrapper;
import com.xdja.imsdk.manager.ModelMapper;
import com.xdja.imsdk.model.internal.IMState;
import java.util.List;
import java.util.Map;

public class ImSdkDbUtils {
    public static long saveMessage(MessageWrapper wrapper) {
        long rawId = MsgEntryDao.getInstance().insert(wrapper);
        return rawId;
    }

    public static long saveSession(SessionWrapper wrapper) {
        long rawId = SessionEntryDao.getInstance().insert(wrapper);
        return rawId;
    }

    public static void saveOptions(Map<String, String> optionMap) {
        List<OptionsDb> dbs = ModelMapper.getIns().mapOption(optionMap);
        OptionsDao.getInstance().insertBatch(dbs);
    }

    public static void saveReceived(List<SessionWrapper> sessions, List<MessageWrapper> messages, List<DuplicateIdDb> dupIds, List<IMState> bombs, List<IMState> dupes, List<IMState> recs) {
        List<LocalStateMsgDb> lBombs = ModelMapper.getIns().mapLStates(bombs);
        List<LocalStateMsgDb> lDupes = ModelMapper.getIns().mapLStates(dupes);
        List<LocalStateMsgDb> lRecs = ModelMapper.getIns().mapLStates(recs);
        MsgEntryDao.getInstance().insertBatch(sessions, messages, dupIds, lBombs, lDupes, lRecs);
    }

    public static void saveSyncIdBatch(List<SyncIdDb> syncIds) {
        if (SyncIdDao.getInstance().getCount() == 0) {
            SyncIdDao.getInstance().insertBatch(syncIds);
        }
    }

    public static void saveSyncId(List<SyncIdDb> syncIds) {
        SyncIdDao.getInstance().insertBatch(syncIds);
    }

    public static int getSyncIdCount() {
        return SyncIdDao.getInstance().getCount();
    }

    public static boolean syncVersionOld() {
        return ImSdkDbUtils.getSyncIdCount() == 4;
    }

    public static long saveLocal(LocalStateMsgDb local) {
        return LocalStateMsgDao.getInstance().insert(local);
    }

    public static int delete(DelArgs args) {
        int result = 0;
        switch (args.getType()) {
            case 1: 
            case 2: {
                result = SessionEntryDao.getInstance().deleteS(ImSdkDbUtils.delArgs2Sql(args));
                break;
            }
            case 3: 
            case 4: {
                result = MsgEntryDao.getInstance().deleteMsg(ImSdkDbUtils.delArgs2Sql(args));
                break;
            }
            case 5: {
                result = LocalStateMsgDao.getInstance().deleteL(ImSdkDbUtils.delArgs2Sql(args));
                break;
            }
            case 6: {
                result = FileMsgDao.getInstance().deleteFile(ImSdkDbUtils.delArgs2Sql(args));
                break;
            }
            case 7: {
                result = HdThumbFileDao.getInstance().deleteHd(ImSdkDbUtils.delArgs2Sql(args));
                break;
            }
            case 8: {
                result = RawFileDao.getInstance().deleteRaw(ImSdkDbUtils.delArgs2Sql(args));
                break;
            }
        }
        return result;
    }

    public static int update(UpdateArgs args) {
        if (args == null) {
            return -1;
        }
        ContentValues values = args.getValues();
        String[] whereClause = args.getWhereClause();
        String[] whereArgs = args.getWhereArgs();
        if (values.size() == 0 || whereClause == null || whereArgs == null || whereClause.length != whereArgs.length) {
            return -1;
        }
        switch (args.getName()) {
            case "session_entry": {
                SessionEntryDao.getInstance().updateS(args);
                break;
            }
            case "msg_entry": {
                MsgEntryDao.getInstance().updateM(args);
                break;
            }
            case "file_msg": {
                FileMsgDao.getInstance().updateF(args);
                break;
            }
            case "hd_thumb_file": {
                HdThumbFileDao.getInstance().updateH(args);
                break;
            }
            case "raw_file": {
                RawFileDao.getInstance().updateR(args);
                break;
            }
            case "sync_id": {
                SyncIdDao.getInstance().updateS(args);
                break;
            }
        }
        return 0;
    }

    public static void updateBatch(List<UpdateArgs> args) {
        if (args == null || args.isEmpty()) {
            return;
        }
        if ("msg_entry".equals(args.get(0).getName())) {
            MsgEntryDao.getInstance().updateMBatch(args);
        }
        if ("sync_id".equals(args.get(0).getName())) {
            SyncIdDao.getInstance().updateSBatch(args);
        }
    }

    public static void updateMF(UpdateArgs message, UpdateArgs file) {
        MsgEntryDao.getInstance().updateMFState(message, file);
    }

    public static void updateEF(UpdateArgs msg, UpdateArgs file, UpdateArgs hd, UpdateArgs raw) {
        MsgEntryDao.getInstance().updateEF(msg, file, hd, raw);
    }

    public static void updateAndSave(UpdateArgs args, IMState state) {
        LocalStateMsgDb lState = ModelMapper.getIns().mapState(state);
        MsgEntryDao.getInstance().updateAndSave(args, lState);
    }

    public static void updateAndSaveBatch(List<UpdateArgs> args, List<IMState> states) {
        List<LocalStateMsgDb> lStates = ModelMapper.getIns().mapLStates(states);
        MsgEntryDao.getInstance().updateAndSaveBatch(args, lStates);
    }

    public static List<SessionWrapper> querySessions(String tag, int size) {
        return SessionEntryDao.getInstance().getSessions(tag, size);
    }

    public static List<SessionWrapper> querySessions(String query, OptType.SQuery type) {
        return SessionEntryDao.getInstance().getSessions(query, type);
    }

    public static SessionWrapper querySession(String query, OptType.SQuery type) {
        return SessionEntryDao.getInstance().getSession(query, type);
    }

    public static List<MessageWrapper> queryMessages(String query, OptType.MQuery type) {
        return MsgEntryDao.getInstance().getMessages(query, type);
    }

    public static List<MessageWrapper> queryDup(String query) {
        return MsgEntryDao.getInstance().getDup(query);
    }

    public static MessageWrapper queryMessage(String query, OptType.MQuery type) {
        return MsgEntryDao.getInstance().getMessage(query, type);
    }

    public static MessageWrapper queryMessage(String query, ImSdkFileConstant.FileType type) {
        return MsgEntryDao.getInstance().getMessage(query, type);
    }

    public static int queryRemindCount(String query) {
        return SessionEntryDao.getInstance().getRemind(query);
    }

    public static List<String> querySessions(String query) {
        return SessionEntryDao.getInstance().querySessions(query);
    }

    public static List<Long> queryIds(String query) {
        return MsgEntryDao.getInstance().getIds(query);
    }

    public static List<MessageWrapper> querySent(String query) {
        return MsgEntryDao.getInstance().getSent(query);
    }

    public static Map<Long, Integer> queryMStates(String query) {
        return MsgEntryDao.getInstance().getStates(query);
    }

    public static List<String> queryPaths(String query) {
        return MsgEntryDao.getInstance().getCachePath(query);
    }

    public static List<LocalStateMsgDb> queryStates() {
        return LocalStateMsgDao.getInstance().getStates();
    }

    public static Map<String, String> queryOptions() {
        return ModelMapper.getIns().mapOption(OptionsDao.getInstance().getAll());
    }

    public static long querySyncId(String key) {
        return SyncIdDao.getInstance().getSyncId(key);
    }

    public static List<Long> queryDelIds(String query) {
        return DeletedMsgDao.getInstance().getIds(query);
    }

    private static String delArgs2Sql(DelArgs args) {
        String sql = "";
        int type = args.getType();
        switch (type) {
            case 1: {
                sql = SessionEntryBuilder.delSql(args.getTags());
                break;
            }
            case 2: {
                sql = SessionEntryBuilder.delAll();
                break;
            }
            case 3: {
                sql = MsgEntryBuilder.delSql(args.getIds());
                break;
            }
            case 4: {
                sql = MsgEntryBuilder.delSql(args.getTag());
                break;
            }
            case 5: {
                sql = LocalStateMsgBuilder.delSql(args.getTag());
                break;
            }
            case 6: {
                sql = FileMsgBuilder.delSql(args.getTag());
                break;
            }
            case 7: {
                sql = HdThumbFileBuilder.delSql(args.getTag());
                break;
            }
            case 8: {
                sql = RawFileBuilder.delSql(args.getTag());
                break;
            }
        }
        return sql;
    }
}

