/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.db.dao;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import com.xdja.imsdk.db.bean.FileMsgDb;
import com.xdja.imsdk.db.builder.FileMsgBuilder;
import com.xdja.imsdk.db.dao.AbstractDao;
import com.xdja.imsdk.db.helper.UpdateArgs;
import java.util.List;

public class FileMsgDao
extends AbstractDao<FileMsgDb> {
    private static FileMsgDao instance;

    private FileMsgDao() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileMsgDao getInstance() {
        if (instance != null) return instance;
        Class<FileMsgDao> clazz = FileMsgDao.class;
        synchronized (FileMsgDao.class) {
            if (instance != null) return instance;
            instance = new FileMsgDao();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public long insert(SQLiteDatabase db, FileMsgDb fileMsgDb) {
        return this.insert(db, fileMsgDb, FileMsgBuilder.insertSql());
    }

    public void insertBatchUpgrade(SQLiteDatabase db, List<FileMsgDb> files) {
        if (files == null || files.isEmpty()) {
            return;
        }
        this.insertBatchUpgrade(db, files, FileMsgBuilder.insertSql());
    }

    public int deleteFile(String sql) {
        return this.delete(sql);
    }

    public void updateF(UpdateArgs args) {
        this.update(args);
    }

    @Override
    protected void bindValues(SQLiteStatement stmt, FileMsgDb entity) {
        String extra_info;
        Integer type;
        Long msg_id;
        Integer file_state;
        String fid;
        String suffix;
        Long translate_size;
        Long encrypt_size;
        Long file_size;
        String file_name;
        String entityFile_path;
        String file_path;
        stmt.clearBindings();
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id.longValue());
        }
        if ((file_path = entity.getFile_path()) != null) {
            stmt.bindString(2, file_path);
        }
        if ((entityFile_path = entity.getEncrypt_path()) != null) {
            stmt.bindString(3, entityFile_path);
        }
        if ((file_name = entity.getFile_name()) != null) {
            stmt.bindString(4, file_name);
        }
        if ((file_size = entity.getFile_size()) != null) {
            stmt.bindLong(5, file_size.longValue());
        }
        if ((encrypt_size = entity.getEncrypt_size()) != null) {
            stmt.bindLong(6, encrypt_size.longValue());
        }
        if ((translate_size = entity.getTranslate_size()) != null) {
            stmt.bindLong(7, translate_size.longValue());
        }
        if ((suffix = entity.getSuffix()) != null) {
            stmt.bindString(8, suffix);
        }
        if ((fid = entity.getFid()) != null) {
            stmt.bindString(9, fid);
        }
        if ((file_state = entity.getFile_state()) != null) {
            stmt.bindLong(10, (long)file_state.intValue());
        }
        if ((msg_id = entity.getMsg_id()) != null) {
            stmt.bindLong(11, msg_id.longValue());
        }
        if ((type = entity.getType()) != null) {
            stmt.bindLong(12, (long)type.intValue());
        }
        if ((extra_info = entity.getExtra_info()) != null) {
            stmt.bindString(13, extra_info);
        }
    }

    @Override
    protected FileMsgDb readEntry(Cursor cursor, int offset) {
        FileMsgDb entity = new FileMsgDb(cursor.isNull(offset + 0) ? null : Long.valueOf(cursor.getLong(offset + 0)), cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1), cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3), cursor.isNull(offset + 4) ? null : Long.valueOf(cursor.getLong(offset + 4)), cursor.isNull(offset + 5) ? null : Long.valueOf(cursor.getLong(offset + 5)), cursor.isNull(offset + 6) ? null : Long.valueOf(cursor.getLong(offset + 6)), cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7), cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8), cursor.isNull(offset + 9) ? null : Integer.valueOf(cursor.getInt(offset + 9)), cursor.isNull(offset + 10) ? null : Long.valueOf(cursor.getLong(offset + 10)), cursor.isNull(offset + 11) ? null : Integer.valueOf(cursor.getInt(offset + 11)), cursor.isNull(offset + 12) ? null : cursor.getString(offset + 12));
        return entity;
    }
}

