/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.db.helper;

import android.content.ContentValues;
import android.text.TextUtils;
import com.xdja.imsdk.constant.ImSdkFileConstant;
import com.xdja.imsdk.constant.internal.Constant;
import com.xdja.imsdk.db.builder.DeletedMsgBuilder;
import com.xdja.imsdk.db.builder.MsgEntryBuilder;
import com.xdja.imsdk.db.builder.SessionEntryBuilder;
import com.xdja.imsdk.db.helper.DelArgs;
import com.xdja.imsdk.db.helper.SqlBuilder;
import com.xdja.imsdk.db.helper.UpdateArgs;
import com.xdja.imsdk.manager.ImSdkConfigManager;
import java.util.List;
import java.util.Set;

public class OptHelper {
    private static OptHelper optHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OptHelper getIns() {
        Class<OptHelper> clazz = OptHelper.class;
        synchronized (OptHelper.class) {
            if (optHelper == null) {
                optHelper = Factory.getInstance();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return optHelper;
        }
    }

    public String getRQuery(String tag) {
        if (!TextUtils.isEmpty((CharSequence)tag)) {
            return SessionEntryBuilder.queryR(tag);
        }
        return SessionEntryBuilder.queryRSum();
    }

    public String getMQuery(String tag) {
        return MsgEntryBuilder.queryMax(tag);
    }

    public String getSQuery(Set<String> tags) {
        return SessionEntryBuilder.queryST(tags);
    }

    public String getSMIQuery(long id) {
        return SessionEntryBuilder.querySI(id);
    }

    public String getSMQuery(String tag) {
        return SessionEntryBuilder.querySM(tag);
    }

    public String getSQuery(String tag) {
        return SessionEntryBuilder.queryS(tag);
    }

    public String getTQuery() {
        return SessionEntryBuilder.queryT();
    }

    public String getMQuery(String tag, long begin, int size) {
        return MsgEntryBuilder.queryShow(tag, begin, size);
    }

    public String getIQuery(String tag, long begin, int size) {
        return MsgEntryBuilder.queryImage(tag, begin, size);
    }

    public String getFQuery(String tag) {
        return MsgEntryBuilder.queryFile(tag);
    }

    public String getFQuery() {
        return MsgEntryBuilder.queryFile();
    }

    public String getCMQuery(String tag) {
        return MsgEntryBuilder.queryCMFile(tag);
    }

    public String getCAQuery(String tag) {
        return MsgEntryBuilder.queryCAFile(tag);
    }

    public String getCAllQuery(String tag) {
        return MsgEntryBuilder.queryCAllFile(tag);
    }

    public String getCachePathQuery() {
        return MsgEntryBuilder.queryCacheFile();
    }

    public String getOtherQuery(String tag) {
        return MsgEntryBuilder.queryOtherFile(tag);
    }

    public String getAMQuery(long id) {
        return MsgEntryBuilder.queryAMI(id);
    }

    public String getMIQuery(long id) {
        return MsgEntryBuilder.queryMI(id);
    }

    public String getARBQuery(String account, String tag) {
        if (TextUtils.isEmpty((CharSequence)tag)) {
            return MsgEntryBuilder.queryARM(account);
        }
        StringBuilder builder = new StringBuilder(" WHERE ");
        builder.append("msg_entry").append(".").append("SESSION_FLAG");
        builder.append(" = '").append(tag).append("'");
        return MsgEntryBuilder.queryRM(account, builder.toString());
    }

    public String getARBQuery(String account, List<String> tags) {
        StringBuilder builder = new StringBuilder(" WHERE ");
        builder.append("msg_entry").append(".").append("SESSION_FLAG");
        SqlBuilder.appendColumn(builder, tags);
        return MsgEntryBuilder.queryRM(account, builder.toString());
    }

    public String getMRBQuery(String account, List<Long> ids) {
        StringBuilder builder = new StringBuilder(" WHERE ");
        builder.append("msg_entry").append(".").append("_id");
        SqlBuilder.appendColumn(builder, ids);
        return MsgEntryBuilder.queryRM(account, builder.toString());
    }

    public String getIngQuery(String account, String tag) {
        StringBuilder builder = new StringBuilder(" WHERE ");
        builder.append("msg_entry").append(".").append("SESSION_FLAG");
        builder.append(" = '").append(tag).append("'");
        return MsgEntryBuilder.queryMIng(account, builder.toString());
    }

    public String getIngQuery(String account, List<String> tags) {
        StringBuilder builder = new StringBuilder(" WHERE ");
        builder.append("msg_entry").append(".").append("SESSION_FLAG");
        SqlBuilder.appendColumn(builder, tags);
        return MsgEntryBuilder.queryMIng(account, builder.toString());
    }

    public String getSentQuery(String account) {
        return MsgEntryBuilder.querySent(account);
    }

    public String getDupQuery(List<Long> fsts) {
        StringBuilder builder = new StringBuilder(" WHERE ");
        builder.append("msg_entry").append(".").append("CREATE_TIME");
        SqlBuilder.appendColumn(builder, fsts);
        return MsgEntryBuilder.querySameFst(builder.toString());
    }

    public String getSaveQuery(List<Long> serverIds) {
        StringBuilder builder = new StringBuilder(" WHERE ");
        builder.append("msg_entry").append(".").append("SERVER_ID");
        SqlBuilder.appendColumn(builder, serverIds);
        return MsgEntryBuilder.querySaved(builder.toString());
    }

    public String getStates(List<Long> serverIds) {
        StringBuilder builder = new StringBuilder(" WHERE ");
        builder.append("msg_entry").append(".").append("SERVER_ID");
        SqlBuilder.appendColumn(builder, serverIds);
        return MsgEntryBuilder.queryState(builder.toString());
    }

    public String getMSQuery(List<Long> serverIds) {
        StringBuilder builder = new StringBuilder(" WHERE ");
        builder.append("msg_entry").append(".").append("SERVER_ID");
        SqlBuilder.appendColumn(builder, serverIds);
        return MsgEntryBuilder.queryMS(builder.toString());
    }

    public String getFQuery(long id, ImSdkFileConstant.FileType type) {
        return MsgEntryBuilder.queryFile(id, type);
    }

    public String getDelQuery(List<Long> serverIds) {
        StringBuilder builder = new StringBuilder(" WHERE ");
        builder.append("deleted_msg").append(".").append("SERVER_ID");
        SqlBuilder.appendColumn(builder, serverIds);
        return DeletedMsgBuilder.queryIds(builder.toString());
    }

    public UpdateArgs getRUpdate(String tag, int remind) {
        UpdateArgs args = new UpdateArgs("session_entry");
        ContentValues values = new ContentValues();
        values.put("REMINDED", String.valueOf(remind));
        String[] whereClause = new String[]{"SESSION_FLAG"};
        String[] whereArgs = new String[]{tag};
        args.setValues(values);
        args.setWhereClause(whereClause);
        args.setWhereArgs(whereArgs);
        return args;
    }

    public UpdateArgs getLUpdate(String tag, long lastId, long time) {
        UpdateArgs args = new UpdateArgs("session_entry");
        ContentValues values = new ContentValues();
        values.put("LAST_MSG", String.valueOf(lastId));
        values.put("LAST_TIME", String.valueOf(time));
        String[] whereClause = new String[]{"SESSION_FLAG"};
        String[] whereArgs = new String[]{tag};
        args.setValues(values);
        args.setWhereClause(whereClause);
        args.setWhereArgs(whereArgs);
        return args;
    }

    public UpdateArgs getBombsUpdate(Constant.BodyType type, long id) {
        UpdateArgs args = new UpdateArgs("msg_entry");
        ContentValues values = new ContentValues();
        values.put("STATE", Integer.valueOf(4));
        switch (type) {
            case TEXT: {
                values.put("CONTENT", "");
                break;
            }
            case VOICE: {
                values.put("CONTENT", String.valueOf(1));
                break;
            }
            case IMAGE: {
                values.put("CONTENT", String.valueOf(3));
                break;
            }
            case VIDEO: {
                values.put("CONTENT", String.valueOf(2));
                break;
            }
            case NORMAL: {
                values.put("CONTENT", String.valueOf(0));
                break;
            }
            case UNKNOWN: {
                values.put("CONTENT", String.valueOf(100));
            }
        }
        String[] whereClause = new String[]{"_id"};
        String[] whereArgs = new String[]{String.valueOf(id)};
        args.setValues(values);
        args.setWhereClause(whereClause);
        args.setWhereArgs(whereArgs);
        return args;
    }

    public UpdateArgs getMSUpdate(String id, String serverId) {
        UpdateArgs args = new UpdateArgs("msg_entry");
        ContentValues values = new ContentValues();
        values.put("STATE", Integer.valueOf(1));
        values.put("SERVER_ID", serverId);
        values.put("SENT_TIME", Long.valueOf(ImSdkConfigManager.getInstance().getCurrentMillis()));
        String[] whereClause = new String[]{"_id"};
        String[] whereArgs = new String[]{id};
        args.setValues(values);
        args.setWhereClause(whereClause);
        args.setWhereArgs(whereArgs);
        return args;
    }

    public UpdateArgs getMFUpdate(String id, int code) {
        UpdateArgs args = new UpdateArgs("msg_entry");
        ContentValues values = new ContentValues();
        if (code == 703) {
            values.put("STATE", String.valueOf(-6));
        } else {
            values.put("STATE", String.valueOf(-5));
        }
        String[] whereClause = new String[]{"_id"};
        String[] whereArgs = new String[]{id};
        args.setValues(values);
        args.setWhereClause(whereClause);
        args.setWhereArgs(whereArgs);
        return args;
    }

    public UpdateArgs getAAUpdate(int aState, int fail) {
        UpdateArgs args = new UpdateArgs("msg_entry");
        ContentValues values = new ContentValues();
        values.put("STATE", Integer.valueOf(fail));
        String[] whereClause = new String[]{"STATE"};
        String[] whereArgs = new String[]{String.valueOf(aState)};
        args.setValues(values);
        args.setWhereClause(whereClause);
        args.setWhereArgs(whereArgs);
        return args;
    }

    public UpdateArgs getFAUpdate(int aState, int fail) {
        UpdateArgs args = new UpdateArgs("file_msg");
        ContentValues values = new ContentValues();
        values.put("FILE_STATE", Integer.valueOf(fail));
        String[] whereClause = new String[]{"FILE_STATE"};
        String[] whereArgs = new String[]{String.valueOf(aState)};
        args.setValues(values);
        args.setWhereClause(whereClause);
        args.setWhereArgs(whereArgs);
        return args;
    }

    public UpdateArgs getHAUpdate(int aState, int fail) {
        UpdateArgs args = new UpdateArgs("hd_thumb_file");
        ContentValues values = new ContentValues();
        values.put("HD_STATE", Integer.valueOf(fail));
        String[] whereClause = new String[]{"HD_STATE"};
        String[] whereArgs = new String[]{String.valueOf(aState)};
        args.setValues(values);
        args.setWhereClause(whereClause);
        args.setWhereArgs(whereArgs);
        return args;
    }

    public UpdateArgs getRAUpdate(int aState, int fail) {
        UpdateArgs args = new UpdateArgs("raw_file");
        ContentValues values = new ContentValues();
        values.put("RAW_STATE", Integer.valueOf(fail));
        String[] whereClause = new String[]{"RAW_STATE"};
        String[] whereArgs = new String[]{String.valueOf(aState)};
        args.setValues(values);
        args.setWhereClause(whereClause);
        args.setWhereArgs(whereArgs);
        return args;
    }

    public UpdateArgs getMCUpdate(long id, int state) {
        UpdateArgs args = new UpdateArgs("msg_entry");
        ContentValues values = new ContentValues();
        values.put("STATE", Integer.valueOf(state));
        String[] whereClause = new String[]{"_id"};
        String[] whereArgs = new String[]{String.valueOf(id)};
        args.setValues(values);
        args.setWhereClause(whereClause);
        args.setWhereArgs(whereArgs);
        return args;
    }

    public UpdateArgs getRCUpdate(long id, String content) {
        UpdateArgs args = new UpdateArgs("msg_entry");
        ContentValues values = new ContentValues();
        values.put("STATE", Integer.valueOf(5));
        values.put("CONTENT", content);
        String[] whereClause = new String[]{"_id"};
        String[] whereArgs = new String[]{String.valueOf(id)};
        args.setValues(values);
        args.setWhereClause(whereClause);
        args.setWhereArgs(whereArgs);
        return args;
    }

    public UpdateArgs getMSUpdate(long id, int state) {
        UpdateArgs args = new UpdateArgs("msg_entry");
        ContentValues values = new ContentValues();
        values.put("STATE", Integer.valueOf(state));
        String[] whereClause = new String[]{"_id"};
        String[] whereArgs = new String[]{String.valueOf(id)};
        args.setValues(values);
        args.setWhereClause(whereClause);
        args.setWhereArgs(whereArgs);
        return args;
    }

    public UpdateArgs getEFUpdate(ImSdkFileConstant.FileType type, String path, long encryptSize, int state, long id) {
        UpdateArgs args = new UpdateArgs();
        ContentValues values = new ContentValues();
        String[] whereClause = new String[]{};
        String[] whereArgs = new String[]{String.valueOf(id)};
        switch (type) {
            case IS_SHOW: {
                args.setName("file_msg");
                values.put("ENCRYPT_PATH", path);
                values.put("ENCRYPT_SIZE", Long.valueOf(encryptSize));
                values.put("FILE_STATE", Integer.valueOf(state));
                whereClause = new String[]{"MSG_ID"};
                break;
            }
            case IS_HD: {
                args.setName("hd_thumb_file");
                values.put("HD_ENCRYPT_PATH", path);
                values.put("HD_ENCRYPT_SIZE", Long.valueOf(encryptSize));
                values.put("HD_STATE", Integer.valueOf(state));
                whereClause = new String[]{"HD_MSG_ID"};
                break;
            }
            case IS_RAW: {
                args.setName("raw_file");
                values.put("RAW_ENCRYPT_PATH", path);
                values.put("RAW_ENCRYPT_SIZE", Long.valueOf(encryptSize));
                values.put("RAW_STATE", Integer.valueOf(state));
                whereClause = new String[]{"RAW_MSG_ID"};
            }
        }
        args.setValues(values);
        args.setWhereArgs(whereArgs);
        args.setWhereClause(whereClause);
        return args;
    }

    public UpdateArgs getFFUpdate(ImSdkFileConstant.FileType type, String fid, int state, long id) {
        UpdateArgs args = new UpdateArgs();
        ContentValues values = new ContentValues();
        String[] whereClause = new String[]{};
        String[] whereArgs = new String[]{String.valueOf(id)};
        switch (type) {
            case IS_SHOW: {
                args.setName("file_msg");
                values.put("FID", fid);
                values.put("FILE_STATE", Integer.valueOf(state));
                whereClause = new String[]{"MSG_ID"};
                break;
            }
            case IS_HD: {
                args.setName("hd_thumb_file");
                values.put("HD_FID", fid);
                values.put("HD_STATE", Integer.valueOf(state));
                whereClause = new String[]{"HD_MSG_ID"};
                break;
            }
            case IS_RAW: {
                args.setName("raw_file");
                values.put("RAW_FID", fid);
                values.put("RAW_STATE", Integer.valueOf(state));
                whereClause = new String[]{"RAW_MSG_ID"};
            }
        }
        args.setValues(values);
        args.setWhereArgs(whereArgs);
        args.setWhereClause(whereClause);
        return args;
    }

    public UpdateArgs getFTUpdate(ImSdkFileConstant.FileType type, long size, int state, long id) {
        UpdateArgs args = new UpdateArgs();
        ContentValues values = new ContentValues();
        String[] whereClause = new String[]{};
        String[] whereArgs = new String[]{String.valueOf(id)};
        switch (type) {
            case IS_SHOW: {
                args.setName("file_msg");
                if (size >= 0L) {
                    values.put("TRANSLATE_SIZE", Long.valueOf(size));
                }
                values.put("FILE_STATE", Integer.valueOf(state));
                whereClause = new String[]{"MSG_ID"};
                break;
            }
            case IS_HD: {
                args.setName("hd_thumb_file");
                if (size >= 0L) {
                    values.put("HD_TRANSLATE_SIZE", Long.valueOf(size));
                }
                values.put("HD_STATE", Integer.valueOf(state));
                whereClause = new String[]{"HD_MSG_ID"};
                break;
            }
            case IS_RAW: {
                args.setName("raw_file");
                if (size >= 0L) {
                    values.put("RAW_TRANSLATE_SIZE", Long.valueOf(size));
                }
                values.put("RAW_STATE", Integer.valueOf(state));
                whereClause = new String[]{"RAW_MSG_ID"};
            }
        }
        args.setValues(values);
        args.setWhereArgs(whereArgs);
        args.setWhereClause(whereClause);
        return args;
    }

    public UpdateArgs getDFUpdate(ImSdkFileConstant.FileType type, String path, long size, int state, long id) {
        UpdateArgs args = new UpdateArgs();
        ContentValues values = new ContentValues();
        String[] whereClause = new String[]{};
        String[] whereArgs = new String[]{String.valueOf(id)};
        switch (type) {
            case IS_SHOW: {
                args.setName("file_msg");
                values.put("FILE_PATH", path);
                values.put("FILE_SIZE", Long.valueOf(size));
                values.put("FILE_STATE", Integer.valueOf(state));
                whereClause = new String[]{"MSG_ID"};
                break;
            }
            case IS_HD: {
                args.setName("hd_thumb_file");
                values.put("HD_FILE_PATH", path);
                values.put("HD_FILE_SIZE", Long.valueOf(size));
                values.put("HD_STATE", Integer.valueOf(state));
                whereClause = new String[]{"HD_MSG_ID"};
                break;
            }
            case IS_RAW: {
                args.setName("raw_file");
                values.put("RAW_FILE_PATH", path);
                values.put("RAW_FILE_SIZE", Long.valueOf(size));
                values.put("RAW_STATE", Integer.valueOf(state));
                whereClause = new String[]{"RAW_MSG_ID"};
            }
        }
        args.setValues(values);
        args.setWhereArgs(whereArgs);
        args.setWhereClause(whereClause);
        return args;
    }

    public UpdateArgs getSUpdate(long serverId, int state) {
        UpdateArgs args = new UpdateArgs("msg_entry");
        ContentValues values = new ContentValues();
        values.put("STATE", Integer.valueOf(state));
        String[] whereArgs = new String[]{String.valueOf(serverId), String.valueOf(state)};
        args.setValues(values);
        args.setWhereArgs(whereArgs);
        return args;
    }

    public UpdateArgs getEUpdate(long id, int state, String content) {
        UpdateArgs args = new UpdateArgs("msg_entry");
        ContentValues values = new ContentValues();
        values.put("STATE", Integer.valueOf(state));
        values.put("CONTENT", content);
        String[] whereClause = new String[]{"_id"};
        String[] whereArgs = new String[]{String.valueOf(id)};
        args.setValues(values);
        args.setWhereClause(whereClause);
        args.setWhereArgs(whereArgs);
        return args;
    }

    public UpdateArgs getRecallUpdate(long serverId, int state, String content) {
        UpdateArgs args = new UpdateArgs("msg_entry");
        ContentValues values = new ContentValues();
        values.put("STATE", Integer.valueOf(state));
        values.put("CONTENT", content);
        String[] whereClause = new String[]{"SERVER_ID"};
        String[] whereArgs = new String[]{String.valueOf(serverId)};
        args.setValues(values);
        args.setWhereClause(whereClause);
        args.setWhereArgs(whereArgs);
        return args;
    }

    public UpdateArgs getSyncUpdate(String type, long id) {
        UpdateArgs args = new UpdateArgs("sync_id");
        ContentValues values = new ContentValues();
        values.put("ID_VALUE", Long.valueOf(id));
        String[] whereClause = new String[]{"ID_TYPE"};
        String[] whereArgs = new String[]{type};
        args.setValues(values);
        args.setWhereClause(whereClause);
        args.setWhereArgs(whereArgs);
        return args;
    }

    public DelArgs getSDel(List<String> tags) {
        DelArgs args = new DelArgs(1);
        args.setTags(tags);
        return args;
    }

    public DelArgs getSADel() {
        return new DelArgs(2);
    }

    public DelArgs getMDel(List<Long> ids) {
        DelArgs args = new DelArgs(3);
        args.setIds(ids);
        return args;
    }

    public DelArgs getMSDel(String tag) {
        DelArgs args = new DelArgs(4);
        args.setTag(tag);
        return args;
    }

    public DelArgs getLSDel(String id) {
        DelArgs args = new DelArgs(5);
        args.setTag(id);
        return args;
    }

    public DelArgs getFileDel(long id) {
        DelArgs args = new DelArgs(6);
        args.setTag(String.valueOf(id));
        return args;
    }

    public DelArgs getHDDel(long id) {
        DelArgs args = new DelArgs(7);
        args.setTag(String.valueOf(id));
        return args;
    }

    public DelArgs getRawDel(long id) {
        DelArgs args = new DelArgs(8);
        args.setTag(String.valueOf(id));
        return args;
    }

    private static class Factory {
        private Factory() {
        }

        static OptHelper getInstance() {
            return new OptHelper();
        }
    }
}

