/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.manager;

import android.os.SystemClock;
import android.text.TextUtils;
import com.xdja.imsdk.constant.ImSdkConfig;
import com.xdja.imsdk.db.ImSdkDbUtils;
import com.xdja.imsdk.util.FileUtils;
import com.xdja.imsdk.util.ToolUtils;
import com.xdja.imsdk.util.ValidateUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ImSdkConfigManager {
    private static ImSdkConfigManager instance;
    private Map<String, String> propertyMap = new HashMap<String, String>();
    private String md5Account;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImSdkConfigManager getInstance() {
        Class<ImSdkConfigManager> clazz = ImSdkConfigManager.class;
        synchronized (ImSdkConfigManager.class) {
            if (instance == null) {
                instance = Factory.getInstance();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public int init(String account, String cardId, Map<String, String> property) {
        String clientId;
        this.md5Account = "." + ToolUtils.toMD5(account);
        Map<String, String> options = ImSdkDbUtils.queryOptions();
        String path = property.get("path");
        property.put("rec", FileUtils.getRec(path));
        property.put("path", String.valueOf(FileUtils.getParent(path)) + this.md5Account + File.separator);
        String topic = property.get("push_topic");
        if (TextUtils.isEmpty((CharSequence)topic)) {
            property.put("push_topic", ToolUtils.pushTopic(cardId));
        }
        if (TextUtils.isEmpty((CharSequence)(clientId = property.get("push_client")))) {
            property.put("push_client", ToolUtils.pushClientId(cardId));
        }
        if (options.isEmpty()) {
            this.propertyMap = this.baseConfig();
            if (this.add(property)) {
                this.save(this.propertyMap);
                return 0;
            }
        } else {
            property.put("diff", "0");
            this.propertyMap = options;
            if (this.add(property)) {
                this.save(property);
                return 0;
            }
        }
        this.initCache();
        return -1;
    }

    public void releaseAll() {
        this.propertyMap.clear();
        instance = null;
    }

    private void initCache() {
        ToolUtils.initFile(this.getParentPath());
        ToolUtils.initFile(this.getRecPath());
    }

    public int saveConfig(Map<String, String> property) {
        if (this.add(property)) {
            this.save(property);
            return 0;
        }
        return -1;
    }

    public String getConfigByKey(String key) {
        return this.propertyMap.get(key);
    }

    private boolean add(Map<String, String> custom) {
        boolean checked = true;
        if (custom != null && !custom.isEmpty()) {
            Set<Map.Entry<String, String>> entrySet = custom.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                if (!ValidateUtils.verifyCustomConfig(entry.getKey(), entry.getValue())) {
                    checked = false;
                    break;
                }
                this.propertyMap.put(entry.getKey(), entry.getValue());
                if (!entry.getKey().equals("server")) continue;
                this.propertyMap.put("login", this.getMethodLogin());
                this.propertyMap.put("logout", this.getMethodLogout());
                this.propertyMap.put("getmsg", this.getvMethodGet());
                this.propertyMap.put("sendmsg", this.getMethodSend());
                this.propertyMap.put("statemsg", this.getMethodState());
            }
        }
        return checked;
    }

    private void save(Map<String, String> options) {
        ImSdkDbUtils.saveOptions(options);
    }

    private Map<String, String> baseConfig() {
        HashMap<String, String> base = new HashMap<String, String>();
        base.put("server", "https://11.12.112.249:6699/webrelay/api");
        base.put("file_ad", "dfs.pyis.safecenter.com");
        base.put("file_port", "80");
        base.put("state", "true");
        base.put("change", "true");
        base.put("session", "true");
        base.put("size", "30");
        base.put("thumb", "false");
        base.put("thu_w", "160");
        base.put("thu_h", "120");
        base.put("hd_w", "480");
        base.put("hd_h", "480");
        base.put("path", ImSdkConfig.FILE_PATH);
        base.put("rec", ImSdkConfig.FILE_REC);
        base.put("per", "1");
        base.put("roam", "259200");
        base.put("sync", "0");
        base.put("diff", "0");
        base.put("https", "true");
        base.put("keystore", "");
        base.put("cert", "");
        base.put("encrypt", "true");
        base.put("bomb", "true");
        base.put("preload", "true");
        base.put("origin", "204800");
        base.put("display_mode", "0");
        base.put("decrypt", "true");
        base.put("push_topic", "");
        base.put("push_client", "");
        base.put("ims", "ims");
        base.put("login", "https://11.12.112.249:6699/webrelay/api/ims/login");
        base.put("logout", "https://11.12.112.249:6699/webrelay/api/ims/logout");
        base.put("getmsg", "https://11.12.112.249:6699/webrelay/api/ims/msgcontent");
        base.put("sendmsg", "https://11.12.112.249:6699/webrelay/api/ims/msg");
        base.put("statemsg", "https://11.12.112.249:6699/webrelay/api/ims/msg/state");
        return base;
    }

    public String getImServer() {
        return this.propertyMap.get("server");
    }

    public String getLoginUrl() {
        return this.propertyMap.get("login");
    }

    public String getLogoutUrl() {
        return this.propertyMap.get("logout");
    }

    public String getGetmsgUrl() {
        return this.propertyMap.get("getmsg");
    }

    public String getSendmsgUrl() {
        return this.propertyMap.get("sendmsg");
    }

    public String getStateUrl() {
        return this.propertyMap.get("statemsg");
    }

    public String getParentPath() {
        String path = this.propertyMap.get("path");
        if (TextUtils.isEmpty((CharSequence)path)) {
            path = !TextUtils.isEmpty((CharSequence)this.md5Account) ? String.valueOf(FileUtils.getDefaultParent()) + this.md5Account + File.separator : String.valueOf(FileUtils.getDefaultParent()) + "Unknown" + File.separator;
        }
        if (this.isDecryptMode()) {
            return String.valueOf(path) + "tmp" + File.separator;
        }
        return path;
    }

    public String getCachePath() {
        String path = this.propertyMap.get("path");
        if (TextUtils.isEmpty((CharSequence)path)) {
            path = !TextUtils.isEmpty((CharSequence)this.md5Account) ? String.valueOf(FileUtils.getDefaultParent()) + this.md5Account + File.separator : String.valueOf(FileUtils.getDefaultParent()) + "Unknown" + File.separator;
        }
        return path;
    }

    public String getRecPath() {
        String recPath = this.propertyMap.get("rec");
        if (TextUtils.isEmpty((CharSequence)recPath)) {
            recPath = FileUtils.getDefaultRec();
        }
        if (this.isDecryptMode()) {
            return String.valueOf(recPath) + "tmp" + File.separator;
        }
        return recPath;
    }

    public long getRoam() {
        return ToolUtils.getLong(this.propertyMap.get("roam"));
    }

    public long getSync() {
        return ToolUtils.getLong(this.propertyMap.get("sync"));
    }

    public long getDiff() {
        return ToolUtils.getLong(this.propertyMap.get("diff"));
    }

    public long getCurrentNano() {
        if (this.getDiff() > 0L) {
            return SystemClock.elapsedRealtimeNanos() + this.getDiff();
        }
        return System.currentTimeMillis() * 1000000L;
    }

    public long getCurrentMillis() {
        return this.getCurrentNano() / 1000000L;
    }

    public long getSize() {
        long size = 0L;
        int sizeM = ToolUtils.getInt(this.propertyMap.get("size"));
        size = sizeM * 1024 * 1024;
        return size;
    }

    public int getKeyStore() {
        return ToolUtils.getInt(this.propertyMap.get("keystore"));
    }

    public String getCert() {
        return this.propertyMap.get("cert");
    }

    public String getFileServer() {
        return this.propertyMap.get("file_ad");
    }

    public String getFilePort() {
        return this.propertyMap.get("file_port");
    }

    public boolean isHttps() {
        return "true".equalsIgnoreCase(this.propertyMap.get("https"));
    }

    public boolean needChange() {
        return "true".equalsIgnoreCase(this.propertyMap.get("change"));
    }

    public boolean needEncrypt() {
        return "true".equalsIgnoreCase(this.propertyMap.get("encrypt"));
    }

    public boolean needState() {
        return "true".equalsIgnoreCase(this.propertyMap.get("state"));
    }

    public boolean needSession() {
        return "true".equalsIgnoreCase(this.propertyMap.get("session"));
    }

    public boolean needPreload() {
        return "true".equalsIgnoreCase(this.propertyMap.get("preload"));
    }

    public boolean needThu() {
        return "true".equalsIgnoreCase(this.propertyMap.get("thumb"));
    }

    public int getThuW() {
        return ToolUtils.getInt(this.propertyMap.get("thu_w"));
    }

    public int getThuH() {
        return ToolUtils.getInt(this.propertyMap.get("thu_h"));
    }

    public int getHdThuW() {
        return ToolUtils.getInt(this.propertyMap.get("hd_w"));
    }

    public int getHdThuH() {
        return ToolUtils.getInt(this.propertyMap.get("hd_h"));
    }

    private String getMethodLogin() {
        return String.valueOf(this.getImServer()) + "/" + "ims" + "/" + "login";
    }

    private String getMethodLogout() {
        return String.valueOf(this.getImServer()) + "/" + "ims" + "/" + "logout";
    }

    private String getvMethodGet() {
        return String.valueOf(this.getImServer()) + "/" + "ims" + "/" + "msgcontent";
    }

    private String getMethodSend() {
        return String.valueOf(this.getImServer()) + "/" + "ims" + "/" + "msg";
    }

    private String getMethodState() {
        return String.valueOf(this.getImServer()) + "/" + "ims" + "/" + "msg/state";
    }

    public boolean isDefaultMode() {
        return "0".equals(this.propertyMap.get("display_mode"));
    }

    public boolean isDecryptMode() {
        return "1".equals(this.propertyMap.get("display_mode"));
    }

    public boolean needDecrypt() {
        return this.isDecryptMode() && "true".equalsIgnoreCase(this.propertyMap.get("decrypt"));
    }

    public boolean noDecrypt() {
        return this.isDecryptMode() && "false".equalsIgnoreCase(this.propertyMap.get("decrypt"));
    }

    public int getFlashTime() {
        int time = ToolUtils.getInt(this.propertyMap.get("flash_sms_time"));
        if (time > 0) {
            return time;
        }
        return 9000;
    }

    public String getPushClientId() {
        return this.propertyMap.get("push_client");
    }

    public String getPushTopic() {
        return this.propertyMap.get("push_topic");
    }

    private static class Factory {
        private Factory() {
        }

        static ImSdkConfigManager getInstance() {
            return new ImSdkConfigManager();
        }
    }
}

