/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.manager.process;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.SystemClock;
import com.xdja.imsdk.manager.callback.BombCallback;
import com.xdja.imsdk.manager.process.BombNode;
import com.xdja.imsdk.model.IMMessage;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;

public class BombProcess {
    private BombCallback bombCallback;
    private HandlerThread bombThread;
    private Looper bombLooper;
    private Handler handler;
    private final PriorityBlockingQueue<BombNode> bombQueue = new PriorityBlockingQueue();
    Runnable runnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BombNode node;
            PriorityBlockingQueue priorityBlockingQueue = BombProcess.this.bombQueue;
            synchronized (priorityBlockingQueue) {
                node = (BombNode)BombProcess.this.bombQueue.poll();
            }
            if (node == null || node.getMessage() == null) {
                return;
            }
            BombProcess.this.handler.postDelayed(BombProcess.this.runnable, (long)node.getDelayTime());
            BombProcess.this.bombCallback.BombDestroy(node.getMessage());
            BombProcess.this.refreshQueueWhenRemove();
        }
    };

    public BombProcess(BombCallback bombCallback) {
        this.bombCallback = bombCallback;
        this.bombThread = new HandlerThread("BombProcess", 10);
        this.bombThread.start();
        this.bombLooper = this.bombThread.getLooper();
        this.handler = new Handler(this.bombLooper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IMMessage message) {
        BombNode node = new BombNode(message, SystemClock.elapsedRealtime(), message.getTimeToLive());
        PriorityBlockingQueue<BombNode> priorityBlockingQueue = this.bombQueue;
        synchronized (priorityBlockingQueue) {
            this.refreshQueue();
            this.bombQueue.offer(node);
            this.postFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        PriorityBlockingQueue<BombNode> priorityBlockingQueue = this.bombQueue;
        synchronized (priorityBlockingQueue) {
            this.bombQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        PriorityBlockingQueue<BombNode> priorityBlockingQueue = this.bombQueue;
        synchronized (priorityBlockingQueue) {
            BombNode[] nodes = new BombNode[this.bombQueue.size()];
            nodes = this.bombQueue.toArray(nodes);
            if (nodes.length > 0) {
                for (Long id : ids) {
                    BombNode[] bombNodeArray = nodes;
                    int n = nodes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        BombNode node = bombNodeArray[n2];
                        if (id.longValue() == node.getMessage().getIMMessageId()) {
                            this.bombQueue.remove(node);
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        PriorityBlockingQueue<BombNode> priorityBlockingQueue = this.bombQueue;
        synchronized (priorityBlockingQueue) {
            this.bombQueue.clear();
        }
        if (this.handler == null || this.bombThread == null) {
            return;
        }
        this.bombLooper.quit();
        this.handler = null;
        this.bombThread.quit();
        this.bombThread.interrupt();
        this.bombThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshQueueWhenRemove() {
        PriorityBlockingQueue<BombNode> priorityBlockingQueue = this.bombQueue;
        synchronized (priorityBlockingQueue) {
            this.refreshQueue();
            this.postFirst();
        }
    }

    private void refreshQueue() {
        long now = SystemClock.elapsedRealtime();
        BombNode[] nodes = new BombNode[this.bombQueue.size()];
        if ((nodes = this.bombQueue.toArray(nodes)).length > 0) {
            BombNode[] bombNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                BombNode node = bombNodeArray[n2];
                int delayTime = (int)((long)node.getWholeDelayTime() - (now - node.getInsertQueueTime()));
                if (delayTime < 0) {
                    node.setDelayTime(0);
                } else {
                    node.setDelayTime(delayTime);
                }
                ++n2;
            }
        }
    }

    private void postFirst() {
        BombNode[] nodes = new BombNode[this.bombQueue.size()];
        if ((nodes = this.bombQueue.toArray(nodes)).length > 0) {
            this.handler.removeCallbacks(this.runnable);
            this.handler.postDelayed(this.runnable, (long)nodes[0].getDelayTime());
        }
    }
}

