/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.util;

import android.os.AsyncTask;
import android.os.Environment;
import android.text.TextUtils;
import com.xdja.imsdk.logger.Logger;
import com.xdja.imsdk.manager.ImSdkCallbackManager;
import com.xdja.imsdk.manager.ImSdkConfigManager;
import com.xdja.imsdk.util.RandomStringUtils;
import com.xdja.imsdk.util.ToolUtils;
import java.io.File;
import java.util.List;

public class FileUtils {
    private static int RANDOM = 2;
    private static AsyncTask task;

    public static String getParent(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return FileUtils.getDefaultParent();
        }
        return String.valueOf(path) + "XdjaIm" + File.separator;
    }

    public static String getRec(String path) {
        return String.valueOf(FileUtils.getParent(path)) + "FileRec" + File.separator;
    }

    public static String getDefaultParent() {
        return String.valueOf(Environment.getExternalStorageDirectory().getAbsolutePath()) + File.separator + "XdjaIm" + File.separator;
    }

    public static String getDefaultRec() {
        return String.valueOf(FileUtils.getDefaultParent()) + "FileRec" + File.separator;
    }

    public static String getVoicePath() {
        return FileUtils.getFilePath("Voice");
    }

    public static String getImagePath() {
        return FileUtils.getFilePath("Image");
    }

    public static String getVideoPath() {
        return FileUtils.getFilePath("Video");
    }

    public static String getWebFilePath() {
        return FileUtils.getFilePath("Web");
    }

    public static String getPicFilePath() {
        return FileUtils.getFilePath("Pic");
    }

    public static String getMediaFilePath() {
        return FileUtils.getFilePath("Media");
    }

    private static String getNormalPath() {
        return FileUtils.getFilePath("Normal");
    }

    public static String getUnknownPath() {
        String end = "Unknown" + File.separator;
        String path = String.valueOf(ImSdkConfigManager.getInstance().getParentPath()) + end;
        return FileUtils.initFile(path, end);
    }

    private static String getFilePath(String dir) {
        String end = String.valueOf(dir) + File.separator + RandomStringUtils.randomAlphanumeric(RANDOM) + File.separator + RandomStringUtils.randomAlphanumeric(RANDOM) + File.separator;
        String path = String.valueOf(ImSdkConfigManager.getInstance().getParentPath()) + end;
        return FileUtils.initFile(path, end);
    }

    private static String initFile(String path, String end) {
        if (ToolUtils.initFile(path)) {
            return path;
        }
        path = String.valueOf(FileUtils.getDefaultParent()) + end;
        if (ToolUtils.initFile(path)) {
            return path;
        }
        return FileUtils.getDefaultParent();
    }

    public static String getEncryptPath(int type, String name) {
        if (type == 0) {
            String path = String.valueOf(FileUtils.getNormalPath()) + name;
            return String.valueOf(FileUtils.fileRename(path)) + ".dat";
        }
        return String.valueOf(FileUtils.getRanPath(type, name)) + ".dat";
    }

    public static String getRanPath(int type, String name) {
        String path;
        switch (type) {
            case 1: {
                path = String.valueOf(FileUtils.getVoicePath()) + name;
                break;
            }
            case 3: {
                path = String.valueOf(FileUtils.getImagePath()) + name;
                break;
            }
            case 2: {
                path = String.valueOf(FileUtils.getVideoPath()) + name;
                break;
            }
            case 4: {
                path = String.valueOf(FileUtils.getWebFilePath()) + name;
                break;
            }
            case 5: {
                path = String.valueOf(FileUtils.getPicFilePath()) + name;
                break;
            }
            case 6: {
                path = String.valueOf(FileUtils.getMediaFilePath()) + name;
                break;
            }
            default: {
                path = String.valueOf(FileUtils.getUnknownPath()) + name;
            }
        }
        return FileUtils.fileRename(path);
    }

    public static String getFileRecPath(String name) {
        String path = ImSdkConfigManager.getInstance().getRecPath();
        path = ToolUtils.initFile(path) ? String.valueOf(path) + name : String.valueOf(FileUtils.getDefaultRec()) + name;
        return FileUtils.fileRename(path);
    }

    public static String subDat(String name) {
        return ToolUtils.subString(name, "dat");
    }

    public static String getName(String name) {
        if (!TextUtils.isEmpty((CharSequence)name)) {
            return name;
        }
        return RandomStringUtils.randomAlphanumeric(2);
    }

    public static long getCacheSize(List<String> paths) {
        String path = ImSdkConfigManager.getInstance().getCachePath();
        long size = 0L;
        if (TextUtils.isEmpty((CharSequence)path)) {
            return size;
        }
        FileUtils.getFileSize(path, paths);
        return size;
    }

    public static String fileRename(String path) {
        String encryptPath = String.valueOf(path) + ".dat";
        File file = new File(path);
        File encryptFile = new File(encryptPath);
        String suffix = ToolUtils.getLastString(path, ".");
        String name = ToolUtils.subString(path, suffix);
        int count = 1;
        while (file.exists() || encryptFile.exists()) {
            if (TextUtils.isEmpty((CharSequence)suffix)) {
                path = String.valueOf(name) + "(" + count + ")";
                encryptPath = String.valueOf(path) + ".dat";
            } else {
                path = String.valueOf(name) + "(" + count + ")." + suffix;
                encryptPath = String.valueOf(path) + ".dat";
            }
            file = new File(path);
            encryptFile = new File(encryptPath);
            ++count;
        }
        return path;
    }

    public static void deleteFile(List<String> paths) {
        String path = ImSdkConfigManager.getInstance().getCachePath();
        if (TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        File file = new File(path);
        FileUtils.deleteFile(file, paths);
    }

    public static void deleteFile(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        File file = new File(path);
        FileUtils.deleteFile(file, null);
    }

    public static void deleteFile(File file, List<String> paths) {
        if (file == null) {
            Logger.getLogger().e("ImSdk delete file null parameter");
            return;
        }
        try {
            boolean directory = file.isDirectory();
            if (directory) {
                File[] childFiles = file.listFiles();
                if (childFiles != null) {
                    File[] fileArray = childFiles;
                    int n = childFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File child = fileArray[n2];
                        FileUtils.deleteFile(child, paths);
                        ++n2;
                    }
                } else {
                    Logger.getLogger().d("ImSdk delete file child is null");
                }
            }
            if (FileUtils.invalidPath(file.getAbsolutePath(), paths) && !file.delete()) {
                Logger.getLogger().e("ImSdk delete file fail");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void getFileSize(String path, List<String> paths) {
        if (task != null) {
            return;
        }
        task = new AsyncTask(){
            private long size;

            protected Object doInBackground(Object ... params) {
                String path = (String)params[0];
                List pathList = (List)params[1];
                this.size = 0L;
                this.getSize(path, pathList);
                ImSdkCallbackManager.getInstance().callCacheSize(-1L);
                task = null;
                return null;
            }

            private void getSize(String path, List<String> paths) {
                if (this.isCancelled()) {
                    return;
                }
                File file = new File(path);
                if (file.isDirectory()) {
                    File[] listFiles = file.listFiles();
                    if (listFiles == null) {
                        return;
                    }
                    File[] fileArray = listFiles;
                    int n = listFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File f = fileArray[n2];
                        if (this.isCancelled()) {
                            return;
                        }
                        this.getSize(f.getPath(), paths);
                        ++n2;
                    }
                } else if (FileUtils.invalidPath(file.getAbsolutePath(), paths)) {
                    this.size += file.length();
                    ImSdkCallbackManager.getInstance().callCacheSize(this.size);
                }
            }
        }.execute(new Object[]{path, paths});
    }

    private static boolean invalidPath(String path, List<String> paths) {
        if (paths == null || paths.isEmpty()) {
            return true;
        }
        for (String p : paths) {
            if (!p.equalsIgnoreCase(path)) continue;
            return false;
        }
        return true;
    }

    public static boolean isVideoFile(String suffix) {
        return true;
    }

    public static boolean isImageFile(String suffix) {
        return true;
    }
}

