/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ThumbUtils {
    private static final int MIN_WIDTH = 320;
    private static final int MIN_HEIGHT = 320;
    private static final int MAX_WIDTH = 360;
    private static final int MAX_HEIGHT = 360;
    private static final int HD_THUMB_WIDTH = 720;
    private static final int HD_THUMB_HEIGHT = 1280;

    public static String getHDThumbFilePath(String originalPath, File saveFile) {
        return ThumbUtils.saveBitmap(ThumbUtils.getHDThumbFilePath(originalPath), 75, saveFile);
    }

    public static Bitmap getHDThumbFilePath(String originalPath) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)originalPath, (BitmapFactory.Options)options);
        int outWidth = options.outWidth;
        int outHeight = options.outHeight;
        int maxWidth = 720;
        int maxHeight = 1280;
        int minWidth = 360;
        int minHeight = 360;
        if (outHeight > 0 && outWidth / outHeight >= 4) {
            return null;
        }
        if (outHeight > 0 && outWidth / outHeight > 2) {
            maxWidth *= 2;
            maxHeight = options.outHeight;
        }
        if (outWidth > 0 && outHeight / outWidth >= 4) {
            return null;
        }
        if (outWidth > 0 && outHeight / outWidth > 2) {
            maxHeight *= 2;
            maxWidth = options.outWidth;
        }
        options.inSampleSize = ThumbUtils.calculateInSampleSize(options.outWidth, options.outHeight, minWidth, minHeight, maxWidth, maxHeight);
        options.inDither = false;
        options.inPurgeable = true;
        options.inInputShareable = true;
        options.inJustDecodeBounds = false;
        try {
            return ThumbUtils.createBitmap(ThumbUtils.getDegree(originalPath), ThumbUtils.readImage(originalPath, options));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getThumbFilePath(String originalPath, File saveFile) {
        return ThumbUtils.saveBitmap(ThumbUtils.getThumbFilePath(originalPath), 75, saveFile);
    }

    public static Bitmap getThumbFilePath(String originalPath) {
        Bitmap bitmap;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)originalPath, (BitmapFactory.Options)options);
        int outWidth = options.outWidth;
        int outHeight = options.outHeight;
        int maxWidth = 360;
        int maxHeight = 360;
        int minWidth = 320;
        int minHeight = 320;
        if (outWidth <= 0 || outHeight <= 0) {
            return null;
        }
        if (outWidth < 320 && outHeight < 320) {
            int reqHeight;
            int reqWidth;
            float ratio = (float)options.outWidth * 1.0f / (float)options.outHeight;
            if (ratio > 1.0f) {
                reqWidth = 320;
                reqHeight = (int)((float)outHeight * ((float)reqWidth * 1.0f / (float)outWidth));
            } else {
                reqHeight = 320;
                reqWidth = (int)(320.0f / (float)outHeight * (float)outWidth);
            }
            bitmap = ThumbUtils.scaledBitmap(originalPath, reqWidth, reqHeight);
        } else if (outHeight > 0 && outWidth / outHeight > 3) {
            int reqWidth = maxWidth;
            int reqHeight = outHeight;
            if (outHeight < minHeight) {
                reqWidth = (int)((float)maxWidth * ((float)outHeight * 1.0f / (float)minHeight));
            }
            options.inSampleSize = ThumbUtils.calculateInSampleSize(outWidth, outHeight, maxWidth, maxHeight, maxWidth * 3, maxHeight);
            options.inJustDecodeBounds = false;
            bitmap = ThumbUtils.cropCenterBitmap(originalPath, reqWidth, reqHeight, options);
        } else if (outWidth > 0 && outHeight / outWidth > 3) {
            int reqWidth = outWidth;
            int reqHeight = maxHeight;
            if (outWidth < minWidth) {
                reqHeight = (int)((float)maxHeight * ((float)outWidth * 1.0f / (float)minWidth));
            }
            options.inSampleSize = ThumbUtils.calculateInSampleSize(outWidth, outHeight, maxWidth, maxHeight, maxWidth, maxHeight * 3);
            options.inJustDecodeBounds = false;
            bitmap = ThumbUtils.cropCenterBitmap(originalPath, reqWidth, reqHeight, options);
        } else {
            options.inJustDecodeBounds = false;
            options.inSampleSize = ThumbUtils.calculateInSampleSize(options.outWidth, options.outHeight, 320, 320, maxWidth, maxHeight);
            options.inDither = false;
            options.inPurgeable = true;
            options.inInputShareable = true;
            bitmap = ThumbUtils.createBitmap(ThumbUtils.getDegree(originalPath), ThumbUtils.readImage(originalPath, options));
        }
        return bitmap;
    }

    public static Bitmap readImage(String originalPath, BitmapFactory.Options options) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(originalPath));
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)fis, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static Bitmap createBitmap(int degree, Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        Bitmap rotateBitmap = null;
        try {
            Matrix matrix = new Matrix();
            matrix.postRotate((float)degree);
            Bitmap bitmap2 = rotateBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            return bitmap2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        finally {
            if (!bitmap.equals(rotateBitmap)) {
                bitmap.recycle();
            }
        }
        return null;
    }

    private static Bitmap scaledBitmap(String filePath, int reqWidth, int reqHeight) {
        Bitmap bitmap = BitmapFactory.decodeFile((String)filePath);
        Bitmap scaledBitmap = null;
        try {
            Bitmap bitmap2 = scaledBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)reqWidth, (int)reqHeight, (boolean)false);
            return bitmap2;
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (!bitmap.equals(scaledBitmap)) {
                bitmap.recycle();
            }
        }
        return null;
    }

    private static Bitmap cropCenterBitmap(String filePath, int reqWidth, int reqHeight, BitmapFactory.Options options) {
        Bitmap bitmap = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        if (bitmap == null) {
            return null;
        }
        int xTopLeft = 0;
        int yTopLeft = 0;
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        if (width > reqWidth) {
            xTopLeft = (width - reqWidth) / 2;
        } else {
            reqWidth = width;
        }
        if (height > reqHeight) {
            yTopLeft = (height - reqHeight) / 2;
        } else {
            reqHeight = height;
        }
        Matrix matrix = new Matrix();
        matrix.postRotate((float)ThumbUtils.getDegree(filePath));
        Bitmap cropBitmap = null;
        try {
            Bitmap bitmap2 = cropBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)xTopLeft, (int)yTopLeft, (int)reqWidth, (int)reqHeight, (Matrix)matrix, (boolean)true);
            return bitmap2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        finally {
            if (!bitmap.equals(cropBitmap)) {
                bitmap.recycle();
            }
        }
        return null;
    }

    public static int getDegree(String filePath) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(filePath);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }

    private static int calculateInSampleSize(int outWidth, int outHeight, int minWidth, int minHeight, int maxWidth, int maxHeight) {
        int heightRatio;
        int widthRatio;
        int height;
        int width;
        int inSampleSize = 1;
        if (outWidth < maxWidth && outHeight < maxHeight) {
            return inSampleSize;
        }
        if (outWidth / maxWidth > outHeight / maxHeight) {
            if (outWidth >= maxWidth) {
                width = maxWidth;
                height = outHeight * maxWidth / outWidth;
            } else {
                width = outWidth;
                height = outHeight;
            }
            if (outHeight < minHeight) {
                height = minHeight;
                width = outWidth * minHeight / outHeight;
                if (width > maxWidth) {
                    width = maxWidth;
                }
            }
        } else {
            if (outHeight >= maxHeight) {
                height = maxHeight;
                width = outWidth * maxHeight / outHeight;
            } else {
                width = outWidth;
                height = outHeight;
            }
            if (outWidth < minWidth) {
                width = minWidth;
                height = outHeight * minWidth / outWidth;
                if (height > maxHeight) {
                    height = maxHeight;
                }
            }
        }
        if ((inSampleSize = Math.max(widthRatio = Math.round((float)outWidth / (float)width), heightRatio = Math.round((float)outHeight / (float)height))) <= 1) {
            inSampleSize = 1;
        }
        return inSampleSize;
    }

    public static String saveBitmap(Bitmap bitmap, int quality, File saveFile) {
        boolean bSaveRet;
        block19: {
            if (saveFile == null || bitmap == null) {
                return null;
            }
            if (!saveFile.getParentFile().exists()) {
                saveFile.getParentFile().mkdirs();
            }
            FilterOutputStream bos = null;
            bSaveRet = false;
            try {
                try {
                    saveFile.createNewFile();
                    bos = new BufferedOutputStream(new FileOutputStream(saveFile));
                    bSaveRet = bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)bos);
                    ((BufferedOutputStream)bos).flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (bos != null) {
                            bos.close();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    if (bitmap != null) {
                        bitmap.recycle();
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (bos != null) {
                        bos.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (bitmap != null) {
                    bitmap.recycle();
                }
                throw throwable;
            }
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (bitmap != null) {
                bitmap.recycle();
            }
        }
        return bSaveRet ? saveFile.getAbsolutePath() : null;
    }

    public static String copyFile(String srcFilePath, File destFile) {
        File srcFile = new File(srcFilePath);
        if (!srcFile.exists()) {
            return null;
        }
        if (destFile.exists()) {
            return srcFilePath;
        }
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(srcFilePath));
            bos = new BufferedOutputStream(new FileOutputStream(destFile));
            destFile.createNewFile();
            byte[] buffer = new byte[1024];
            int readLen = 0;
            while ((readLen = bis.read(buffer)) != -1) {
                ((BufferedOutputStream)bos).write(buffer, 0, readLen);
            }
            ((BufferedOutputStream)bos).flush();
            String string2 = destFile.getAbsolutePath();
            return string2;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return srcFilePath;
    }
}

