/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.volley;

import android.annotation.TargetApi;
import android.net.TrafficStats;
import android.os.Build;
import android.os.Process;
import android.os.SystemClock;
import com.xdja.imsdk.volley.Network;
import com.xdja.imsdk.volley.NetworkResponse;
import com.xdja.imsdk.volley.Request;
import com.xdja.imsdk.volley.Response;
import com.xdja.imsdk.volley.VolleyLog;
import com.xdja.imsdk.volley.error.VolleyError;
import java.util.concurrent.BlockingQueue;

public class NetworkDispatcher
extends Thread {
    private final BlockingQueue<Request<?>> mQueue;
    private final Network mNetwork;
    private volatile boolean mQuit = false;
    private volatile boolean mPause = false;
    private Object mPauseLock = new Object();

    public NetworkDispatcher(BlockingQueue<Request<?>> queue, Network network) {
        this.mQueue = queue;
        this.mNetwork = network;
    }

    public void quit() {
        this.resumeTask();
        this.mQuit = true;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeTask() {
        this.mPause = false;
        Object object = this.mPauseLock;
        synchronized (object) {
            this.mPauseLock.notifyAll();
        }
    }

    public void pauseTask() {
        this.mPause = true;
    }

    @TargetApi(value=14)
    private void addTrafficStatsTag(Request<?> request) {
        if (Build.VERSION.SDK_INT >= 14) {
            TrafficStats.setThreadStatsTag((int)request.getTrafficStatsTag());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        while (true) {
            Request<?> request;
            long startTimeMs = SystemClock.elapsedRealtime();
            try {
                if (this.mPause) {
                    Object object = this.mPauseLock;
                    synchronized (object) {
                        this.mPauseLock.wait();
                    }
                }
                VolleyLog.d("Take a request from the queue " + this.mQueue.size() + ", Thread:" + this.getName(), new Object[0]);
                request = this.mQueue.take();
            }
            catch (InterruptedException e) {
                if (!this.mQuit) continue;
                return;
            }
            try {
                request.addMarker("network-queue-take");
                if (request.isCanceled()) {
                    request.finish("network-discard-cancelled");
                    continue;
                }
                this.addTrafficStatsTag(request);
                NetworkResponse networkResponse = this.mNetwork.performRequest(request);
                request.addMarker("network-http-complete");
                if (networkResponse.notModified && request.hasHadResponseDelivered()) {
                    request.finish("not-modified");
                    continue;
                }
                Response<?> response = request.parseNetworkResponse(networkResponse);
                request.addMarker("network-parse-complete");
                request.markDelivered();
                this.deliverResponse(request, response);
                continue;
            }
            catch (VolleyError volleyError) {
                request.finish("post-error");
                volleyError.setNetworkTimeMs(SystemClock.elapsedRealtime() - startTimeMs);
                request.deliverError(volleyError);
                continue;
            }
            catch (Exception e) {
                VolleyLog.w(e, "Unhandled exception %s", e.toString());
                request.finish("post-error");
                VolleyError volleyError = new VolleyError(e);
                volleyError.setNetworkTimeMs(SystemClock.elapsedRealtime() - startTimeMs);
                request.deliverError(volleyError);
                continue;
            }
            break;
        }
    }

    public void deliverResponse(Request request, Response response) {
        if (request.isCanceled()) {
            request.finish("canceled-at-delivery");
            request.deliverCanceled();
            return;
        }
        if (response.isSuccess()) {
            request.deliverResponse(response.result);
        } else {
            request.deliverError(response.error);
        }
        if (response.intermediate) {
            request.addMarker("intermediate-response");
        } else {
            request.finish("done");
        }
    }
}

