/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.volley;

import android.net.Uri;
import android.os.SystemClock;
import android.text.TextUtils;
import com.xdja.http.HttpEntity;
import com.xdja.imsdk.volley.Cache;
import com.xdja.imsdk.volley.NetworkResponse;
import com.xdja.imsdk.volley.RequestQueue;
import com.xdja.imsdk.volley.Response;
import com.xdja.imsdk.volley.RetryPolicy;
import com.xdja.imsdk.volley.VolleyLog;
import com.xdja.imsdk.volley.error.AuthFailureError;
import com.xdja.imsdk.volley.error.VolleyError;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public abstract class Request<T>
implements Comparable<Request<T>> {
    protected static final String DEFAULT_PARAMS_ENCODING = "UTF-8";
    private final VolleyLog.MarkerLog mEventLog = VolleyLog.MarkerLog.ENABLED ? new VolleyLog.MarkerLog() : null;
    private final int mMethod;
    private final String mUrl;
    private String mRedirectUrl;
    private File mPostFile;
    private long mTransLateSize;
    private HashMap<String, String> mHashHeaders = new HashMap();
    private final int mDefaultTrafficStatsTag;
    private final Response.ErrorListener mErrorListener;
    private Response.LoadingListener mLoadingListener;
    private Response.CanceledListener mCanceledListener;
    private long mRate = 100L;
    private boolean mShouldGzip = true;
    private Integer mSequence;
    private RequestQueue mRequestQueue;
    private boolean mCanceled = false;
    private int mNetStatusCode;
    private boolean mResponseDelivered = false;
    private long mRequestBirthTime = 0L;
    private static final long SLOW_REQUEST_THRESHOLD_MS = 3000L;
    private RetryPolicy mRetryPolicy;
    private Cache.Entry mCacheEntry = null;
    private Object mTag;
    private HttpEntity mHttpEntity;

    @Deprecated
    public Request(String url, Response.ErrorListener listener) {
        this(-1, url, listener);
    }

    public Request(int method, String url, Response.ErrorListener listener) {
        this(method, url, listener, null);
    }

    public Request(int method, String url, Response.ErrorListener listener, Response.LoadingListener loadingListener) {
        this(method, url, listener, loadingListener, null);
    }

    public Request(int method, String url, Response.ErrorListener listener, Response.LoadingListener loadingListener, Response.CanceledListener canceledListener) {
        this.mMethod = method;
        this.mUrl = url;
        this.mErrorListener = listener;
        this.mLoadingListener = loadingListener;
        this.mCanceledListener = canceledListener;
        this.mDefaultTrafficStatsTag = Request.findDefaultTrafficStatsTag(url);
    }

    public int getMethod() {
        return this.mMethod;
    }

    public Request<?> setTag(Object tag) {
        this.mTag = tag;
        return this;
    }

    public Object getTag() {
        return this.mTag;
    }

    public void setHttpEntity(HttpEntity entity) {
        this.mHttpEntity = entity;
    }

    public HttpEntity getHttpEntity() {
        return this.mHttpEntity;
    }

    public File getPostFile() {
        return this.mPostFile;
    }

    public void setPostFile(File file) {
        this.mPostFile = file;
    }

    public long getTransLateSize() {
        return this.mTransLateSize;
    }

    public void setTransLateSize(long transLateSize) {
        this.mTransLateSize = transLateSize;
    }

    public Response.ErrorListener getErrorListener() {
        return this.mErrorListener;
    }

    public int getTrafficStatsTag() {
        return this.mDefaultTrafficStatsTag;
    }

    private static int findDefaultTrafficStatsTag(String url) {
        String host;
        Uri uri;
        if (!TextUtils.isEmpty((CharSequence)url) && (uri = Uri.parse((String)url)) != null && (host = uri.getHost()) != null) {
            return host.hashCode();
        }
        return 0;
    }

    public Request<?> setRetryPolicy(RetryPolicy retryPolicy) {
        this.mRetryPolicy = retryPolicy;
        return this;
    }

    public void addMarker(String tag) {
        if (VolleyLog.MarkerLog.ENABLED) {
            this.mEventLog.add(tag, Thread.currentThread().getId());
        } else if (this.mRequestBirthTime == 0L) {
            this.mRequestBirthTime = SystemClock.elapsedRealtime();
        }
    }

    public void finish(String tag) {
        if (this.mRequestQueue != null) {
            this.mRequestQueue.finish(this);
        }
        if (VolleyLog.MarkerLog.ENABLED) {
            long threadId = Thread.currentThread().getId();
            this.mEventLog.add(tag, threadId);
            this.mEventLog.finish(this.toString());
        } else {
            long requestTime = SystemClock.elapsedRealtime() - this.mRequestBirthTime;
            if (requestTime >= 3000L) {
                VolleyLog.d("%d ms: %s", requestTime, this.toString());
            }
        }
    }

    public Request<?> setRequestQueue(RequestQueue requestQueue) {
        this.mRequestQueue = requestQueue;
        return this;
    }

    public final Request<?> setSequence(int sequence) {
        this.mSequence = sequence;
        return this;
    }

    public final int getSequence() {
        if (this.mSequence == null) {
            throw new IllegalStateException("getSequence called before setSequence");
        }
        return this.mSequence;
    }

    public String getUrl() {
        return this.mRedirectUrl != null ? this.mRedirectUrl : this.mUrl;
    }

    public String getOriginUrl() {
        return this.mUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.mRedirectUrl = redirectUrl;
    }

    public Request<?> setCacheEntry(Cache.Entry entry) {
        this.mCacheEntry = entry;
        return this;
    }

    public Cache.Entry getCacheEntry() {
        return this.mCacheEntry;
    }

    public void cancel() {
        this.mCanceled = true;
    }

    public void resume() {
        this.mCanceled = false;
    }

    public void onNetChange(int code, String message) {
        this.mNetStatusCode = code;
    }

    public boolean isCanceled() {
        return this.mCanceled;
    }

    public Map<String, String> getHeaders() throws AuthFailureError {
        return this.mHashHeaders;
    }

    public final void addHeader(String field, String value) {
        this.removeHeader(field);
        this.mHashHeaders.put(field, value);
    }

    public final void removeHeader(String field) {
        this.mHashHeaders.remove(field);
    }

    @Deprecated
    protected Map<String, String> getPostParams() throws AuthFailureError {
        return this.getParams();
    }

    @Deprecated
    protected String getPostParamsEncoding() {
        return this.getParamsEncoding();
    }

    @Deprecated
    public String getPostBodyContentType() {
        return this.getBodyContentType();
    }

    @Deprecated
    public byte[] getPostBody() throws AuthFailureError {
        Map<String, String> postParams = this.getPostParams();
        if (postParams != null && postParams.size() > 0) {
            return this.encodeParameters(postParams, this.getPostParamsEncoding());
        }
        return null;
    }

    protected Map<String, String> getParams() throws AuthFailureError {
        return null;
    }

    protected String getParamsEncoding() {
        return DEFAULT_PARAMS_ENCODING;
    }

    public String getBodyContentType() {
        return "application/x-www-form-urlencoded; charset=" + this.getParamsEncoding();
    }

    public byte[] getBody() throws AuthFailureError {
        Map<String, String> params = this.getParams();
        if (params != null && params.size() > 0) {
            return this.encodeParameters(params, this.getParamsEncoding());
        }
        return null;
    }

    private byte[] encodeParameters(Map<String, String> params, String paramsEncoding) {
        StringBuilder encodedParams = new StringBuilder();
        try {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (entry.getValue() == null) continue;
                encodedParams.append(URLEncoder.encode(entry.getKey(), paramsEncoding));
                encodedParams.append('=');
                encodedParams.append(URLEncoder.encode(entry.getValue(), paramsEncoding));
                encodedParams.append('&');
            }
            return encodedParams.toString().getBytes(paramsEncoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Encoding not supported: " + paramsEncoding, uee);
        }
    }

    public void prepare() {
    }

    public NetworkResponse perform() {
        return null;
    }

    public Priority getPriority() {
        return Priority.NORMAL;
    }

    public final int getTimeoutMs() {
        return this.mRetryPolicy.getCurrentTimeout();
    }

    public RetryPolicy getRetryPolicy() {
        return this.mRetryPolicy;
    }

    public void markDelivered() {
        this.mResponseDelivered = true;
    }

    public boolean hasHadResponseDelivered() {
        return this.mResponseDelivered;
    }

    protected abstract Response<T> parseNetworkResponse(NetworkResponse var1);

    protected VolleyError parseNetworkError(VolleyError volleyError) {
        return volleyError;
    }

    protected abstract void deliverResponse(T var1);

    public void deliverError(VolleyError error) {
        if (this.mErrorListener != null) {
            this.mErrorListener.onErrorResponse(error);
        }
    }

    public void deliverLoading(long count, long translate) {
        if (this.mLoadingListener != null) {
            this.mLoadingListener.onLoading(count, translate);
        }
    }

    public void deliverCanceled() {
        if (this.mCanceledListener != null) {
            this.mCanceledListener.onCanceled();
        }
    }

    @Override
    public int compareTo(Request<T> other) {
        Priority right;
        Priority left = this.getPriority();
        return left == (right = other.getPriority()) ? this.mSequence - other.mSequence : right.ordinal() - left.ordinal();
    }

    public String toString() {
        String trafficStatsTag = "0x" + Integer.toHexString(this.getTrafficStatsTag());
        return String.valueOf(this.mCanceled ? "[X] " : "[ ] ") + this.getUrl() + " " + trafficStatsTag + " " + (Object)((Object)this.getPriority()) + " " + this.mSequence + this.mLoadingListener;
    }

    public Response.LoadingListener getLoadingListener() {
        return this.mLoadingListener;
    }

    public void setLoadingListener(Response.LoadingListener loadingListener) {
        this.mLoadingListener = loadingListener;
    }

    public long getRate() {
        return this.mRate;
    }

    public void setRate(long mRate) {
        this.mRate = mRate;
    }

    public boolean isShouldGzip() {
        return this.mShouldGzip;
    }

    public void setShouldGzip(boolean shouldGzip) {
        this.mShouldGzip = shouldGzip;
    }

    public static interface Method {
        public static final int DEPRECATED_GET_OR_POST = -1;
        public static final int GET = 0;
        public static final int POST = 1;
        public static final int PUT = 2;
        public static final int DELETE = 3;
        public static final int HEAD = 4;
        public static final int OPTIONS = 5;
        public static final int TRACE = 6;
        public static final int PATCH = 7;
    }

    public static enum Priority {
        LOW,
        NORMAL,
        HIGH,
        IMMEDIATE;

    }
}

