/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.volley.request;

import com.xdja.http.HttpEntity;
import com.xdja.imsdk.volley.CustomRetryPolicy;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RequestInfo {
    public String boundary = String.valueOf(System.currentTimeMillis());
    public String url;
    public String tag;
    public String path;
    public boolean isSupportRange;
    public Map<String, String> params = new HashMap<String, String>();
    public Map<String, String> headers = new HashMap<String, String>();
    public Map<String, File> fileParams = new HashMap<String, File>();
    public HttpEntity httpEntity;
    public CustomRetryPolicy retryPolicy;

    public RequestInfo() {
    }

    public RequestInfo(String url, Map<String, String> params) {
        this.url = url;
        this.params = params;
    }

    public String getFullUrl() {
        if (this.url != null && this.params != null) {
            StringBuilder sb = new StringBuilder();
            if (!this.url.contains("?")) {
                this.url = String.valueOf(this.url) + "?";
            } else if (!this.url.endsWith("?")) {
                this.url = String.valueOf(this.url) + "&";
            }
            Iterator<String> iterotor = this.params.keySet().iterator();
            try {
                while (iterotor.hasNext()) {
                    String key = iterotor.next();
                    if (key == null || this.params.get(key) == null) continue;
                    sb.append(URLEncoder.encode(key, "utf-8")).append("=").append(URLEncoder.encode(this.params.get(key), "utf-8")).append("&");
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (sb.length() > 0 && sb.lastIndexOf("&") == sb.length() - 1) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return String.valueOf(this.url) + sb.toString();
        }
        return this.url;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public String getTag() {
        return this.tag;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public Map<String, File> getFileParams() {
        return this.fileParams;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHttpEntity(HttpEntity entity) {
        this.httpEntity = entity;
    }

    public HttpEntity getHttpEntity() {
        return this.httpEntity;
    }

    public void put(String key, String value) {
        this.params.put(key, value);
    }

    public void putHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void putHeader(Map<String, String> headers) {
        this.headers.putAll(headers);
    }

    public void put(String key, File file) {
        if (this.fileParams.containsKey(key)) {
            this.fileParams.put(String.valueOf(key) + this.boundary + this.fileParams.size(), file);
        } else {
            this.fileParams.put(key, file);
        }
    }

    public void putFile(String key, String path) {
        if (this.fileParams.containsKey(key)) {
            this.fileParams.put(String.valueOf(key) + this.boundary + this.fileParams.size(), new File(path));
        } else {
            this.fileParams.put(key, new File(path));
        }
    }

    public void putAllParams(Map<String, Object> objectParams) {
        for (String key : objectParams.keySet()) {
            Object value = objectParams.get(key);
            if (value instanceof String) {
                this.put(key, (String)value);
                continue;
            }
            if (!(value instanceof File)) continue;
            this.put(key, (File)value);
        }
    }
}

