/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.imsdk.volley.toolbox;

import android.text.TextUtils;
import com.xdja.imsdk.volley.CustomRetryPolicy;
import com.xdja.imsdk.volley.RequestQueue;
import com.xdja.imsdk.volley.Response;
import com.xdja.imsdk.volley.VolleyLog;
import com.xdja.imsdk.volley.error.CancelError;
import com.xdja.imsdk.volley.error.VolleyError;
import com.xdja.imsdk.volley.request.UploadRequest;
import com.xdja.imsdk.volley.toolbox.HttpCallback;
import java.util.LinkedList;

public class FileUploader {
    private static final int STATUS_WAITING = 0;
    private static final int STATUS_DOWNLOADING = 1;
    private static final int STATUS_PAUSE = 2;
    private static final int STATUS_SUCCESS = 3;
    private static final int STATUS_DISCARD = 4;
    private final RequestQueue mUploadRequestQueue;
    private final int mParallelTaskCount;
    private LinkedList<UploadController> mTaskQueue;

    public FileUploader(RequestQueue queue, int taskCount) {
        this.mUploadRequestQueue = queue;
        this.mParallelTaskCount = taskCount;
        this.mTaskQueue = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule() {
        LinkedList<UploadController> linkedList = this.mTaskQueue;
        synchronized (linkedList) {
            int parallelTaskCount = 0;
            for (UploadController controller : this.mTaskQueue) {
                if (!controller.isDownloading()) continue;
                ++parallelTaskCount;
            }
            if (parallelTaskCount >= this.mParallelTaskCount) {
                return;
            }
            for (UploadController controller : this.mTaskQueue) {
                if (!controller.deploy() || ++parallelTaskCount != this.mParallelTaskCount) continue;
                return;
            }
        }
    }

    private boolean isTaskExist(String url, String tag) {
        for (UploadController ctrl : this.mTaskQueue) {
            if (!TextUtils.equals((CharSequence)ctrl.mUrl, (CharSequence)url) || !TextUtils.equals((CharSequence)ctrl.mTag, (CharSequence)tag)) continue;
            VolleyLog.d("task is already exist!", new Object[0]);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String url, String filePath, String requestTag, CustomRetryPolicy policy, HttpCallback callback) {
        LinkedList<UploadController> linkedList = this.mTaskQueue;
        synchronized (linkedList) {
            if (this.isTaskExist(url, requestTag)) {
                return;
            }
            UploadController controller = new UploadController(url, filePath, requestTag, policy, callback);
            this.mTaskQueue.add(controller);
            this.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UploadController get(String tag) {
        VolleyLog.d("UploadController.get() tag:" + tag, new Object[0]);
        LinkedList<UploadController> linkedList = this.mTaskQueue;
        synchronized (linkedList) {
            VolleyLog.d("mTaskQueue.size:" + this.mTaskQueue.size(), new Object[0]);
            for (UploadController controller : this.mTaskQueue) {
                if (!controller.mTag.equals(tag)) continue;
                return controller;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(UploadController controller) {
        LinkedList<UploadController> linkedList = this.mTaskQueue;
        synchronized (linkedList) {
            this.mTaskQueue.remove(controller);
        }
        this.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        LinkedList<UploadController> linkedList = this.mTaskQueue;
        synchronized (linkedList) {
            for (UploadController controller : this.mTaskQueue) {
                if (controller == null || controller.mStatus != 1) continue;
                controller.mRequest.cancel();
            }
        }
        this.mTaskQueue.clear();
    }

    public void cancel(String requestTag) {
        UploadController controller = this.get(requestTag);
        if (controller != null) {
            controller.mStatus = 4;
        }
    }

    public class UploadController {
        private String mUrl;
        private String mTag;
        private String mFilePath;
        private HttpCallback mCallback;
        private UploadRequest mRequest;
        private int mStatus;
        private int mPercent;
        private CustomRetryPolicy policy;

        public UploadController(String url, String filePath, String requestTag, CustomRetryPolicy retryPolicy, HttpCallback callback) {
            this.mUrl = url;
            this.mTag = requestTag;
            this.mFilePath = filePath;
            this.mCallback = callback;
            this.policy = retryPolicy == null ? new CustomRetryPolicy() : retryPolicy;
        }

        private boolean deploy() {
            if (this.mStatus != 0) {
                return false;
            }
            this.mRequest = new UploadRequest(1, this.mUrl, new Response.Listener(){

                public void onResponse(Object response) {
                    if (UploadController.this.mCallback != null) {
                        UploadController.this.mStatus = 3;
                        UploadController.this.mCallback.onFinish();
                    }
                    FileUploader.this.remove(UploadController.this);
                }
            }, new Response.ErrorListener(){

                @Override
                public void onErrorResponse(VolleyError error) {
                    VolleyLog.d("onErrorResponse:" + (error == null ? "" : error.getMessage()), new Object[0]);
                    if (UploadController.this.mCallback != null && UploadController.this.mStatus != 2) {
                        VolleyLog.d("remove controller and callback onError. ", new Object[0]);
                        if (!(error instanceof CancelError)) {
                            UploadController.this.mCallback.onError(error);
                        }
                        FileUploader.this.remove(UploadController.this);
                    }
                }
            }, new Response.LoadingListener(){

                @Override
                public void onLoading(long count, long translate) {
                    int percent;
                    if (!(UploadController.this.mCallback == null || UploadController.this.mRequest.isCanceled() || count <= 0L || (percent = (int)((float)translate * 100.0f / (float)count)) <= UploadController.this.mPercent && percent != 100)) {
                        UploadController.this.mPercent = percent;
                        UploadController.this.mCallback.onLoading(count, translate, percent);
                    }
                }
            }, new Response.CanceledListener(){

                @Override
                public void onCanceled() {
                    VolleyLog.d("Upload Canceled for:" + UploadController.this.toString(), new Object[0]);
                    if (UploadController.this.mStatus == 2) {
                        if (UploadController.this.mCallback != null) {
                            UploadController.this.mCallback.onCanceled();
                        }
                    } else {
                        UploadController.this.mPercent = 0;
                        FileUploader.this.remove(UploadController.this);
                    }
                }
            }){

                @Override
                public void onNetChange(int code, String message) {
                    super.onNetChange(code, message);
                    if (UploadController.this.mCallback != null) {
                        UploadController.this.mCallback.onNetChanged(code, message);
                    }
                }
            };
            if (this.mCallback != null) {
                this.mCallback.onStart();
            }
            this.mStatus = 1;
            this.mRequest.setRetryPolicy(this.policy);
            this.mRequest.setUploadFile(this.mFilePath);
            this.mRequest.setTag(this.mTag);
            FileUploader.this.mUploadRequestQueue.add(this.mRequest);
            return true;
        }

        public int getStatus() {
            return this.mStatus;
        }

        public boolean isDownloading() {
            return this.mStatus == 1;
        }

        public boolean pause() {
            VolleyLog.d("UploadController.pause...mStatus:" + this.mStatus, new Object[0]);
            switch (this.mStatus) {
                case 1: {
                    this.mStatus = 2;
                    this.mRequest.cancel();
                    FileUploader.this.mUploadRequestQueue.cancelAll(this.mTag);
                }
                case 0: {
                    this.mStatus = 2;
                    return true;
                }
            }
            return false;
        }

        public boolean resume() {
            VolleyLog.d("UploadController.resume...", new Object[0]);
            if (this.mStatus == 2) {
                this.mStatus = 0;
                this.mRequest.resume();
                this.mRequest.prepare();
                FileUploader.this.schedule();
                return true;
            }
            return false;
        }

        public boolean stop() {
            VolleyLog.d("UploadController.discard...", new Object[0]);
            if (this.mStatus == 4) {
                return false;
            }
            if (this.mStatus == 3) {
                return false;
            }
            if (this.mStatus == 1) {
                this.mRequest.cancel();
            }
            this.mStatus = 4;
            FileUploader.this.remove(this);
            return true;
        }

        public String toString() {
            return "UploadController{mUrl='" + this.mUrl + '\'' + ", mTag='" + this.mTag + '\'' + ", mFilePath='" + this.mFilePath + '\'' + ", mStatus=" + this.mStatus + ", mPercent=" + this.mPercent + '}';
        }
    }
}

