package com.xdja.im.base.di;

import android.support.annotation.StringDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * @Package: com.xdja.im.uikit.config
 * @Author: xdjaxa
 * @Date: 2017-04-10 21:02
 * @Version V1.0
 * @Comment:
 */
public class DiConfig {

    @Retention(RetentionPolicy.SOURCE)
    @StringDef(value = {CONTEXT_SCOPE_APP, CONTEXT_SCOPE_ACTIVITY})
    public @interface ContextScope {
    }

    /**
     * 全局Context标签
     */
    public static final String CONTEXT_SCOPE_APP = "application";

    /**
     * Activity Context标签
     */
    public static final String CONTEXT_SCOPE_ACTIVITY = "activity";

    @Retention(RetentionPolicy.SOURCE)
    @StringDef(value = {CONN_HTTP, CONN_HTTPS})
    public @interface ConnType {
    }

    /**
     * http链接
     */
    public static final String CONN_HTTP = "http";
    /**
     * https链接
     */
    public static final String CONN_HTTPS = "https";

    @Retention(RetentionPolicy.SOURCE)
    @StringDef(value = {
            TYPE_CLOUD,
            TYPE_DISK,
            TYPE_MEMORY
    })
    public @interface StoreType {
    }

    public static final String TYPE_DISK = "disk";

    public static final String TYPE_CLOUD = "cloud";

    public static final String TYPE_MEMORY = "memory";

    @Retention(RetentionPolicy.SOURCE)
    @StringDef(value = {
            TYPE_FASTDFS,
            TYPE_PN
    })
    public @interface ConfigType {
    }

    /**
     * FastDfs配置
     */
    public static final String TYPE_FASTDFS = "fastDfs";
    /**
     * push配置
     */
    public static final String TYPE_PN = "pn";
}
