package com.xdja.im.base.di.component;

import com.xdja.im.base.di.module.ActivityModule;
import com.xdja.im.base.di.module.FragmentModule;
import com.xdja.im.base.di.scope.ActivityScope;
import com.xdja.im.core.service.KitService;
import com.xdja.im.lib.file.ui.activity.FileExplorerActivity;
import com.xdja.im.lib.file.ui.fragment.FileListFragment;
import com.xdja.im.uikit.ui.activity.ChatListActivity;
import com.xdja.im.uikit.ui.activity.FileDownloadActivity;
import com.xdja.im.uikit.ui.activity.FilePreviewActivity;
import com.xdja.im.uikit.ui.fragment.ChatListFragment;
import com.xdja.im.uikit.ui.fragment.SessionListFragment;

import dagger.Component;

/**
 * @Package: com.xdja.im.base.di.component
 * @Author: xdjaxa
 * @Creation: 2017-05-04 19:20
 * @Version V1.0
 * @Description:
 */
@ActivityScope
@Component(modules = {ActivityModule.class, FragmentModule.class},
        dependencies = RepositoryComponent.class)
public interface UserComponent {

    void inject(SessionListFragment fragment);

    void inject(ChatListFragment fragment);

    void inject(ChatListActivity activity);

    void inject(FileListFragment fileListFragment);

    void inject(FileExplorerActivity activity);

    void inject(FileDownloadActivity activity);

    void inject(FilePreviewActivity activity);

    void inject(KitService service);
}
