package com.xdja.im.base.frame.view;

import android.app.Activity;
import android.support.annotation.StringRes;

import com.xdja.im.base.frame.Presenter;
import com.xdja.im.base.frame.BaseView;

/**
 * @Package: com.xdja.im.base.frame.view
 * @Author: xdjaxa
 * @Date: 2017-04-10 20:05
 * @Version V1.0
 * @Comment: 和Activity生命周期相关的View层的生命周期定义
 */
public interface ActivityBaseView<P extends Presenter> extends BaseView<P> {

    /**
     * 设置和view绑定的Activity
     *
     * @param activity 目标Activity
     */
    <A extends Activity> void setActivity(A activity);



    void showToast(String msg);

    void showToast(@StringRes int resId);
}
