package com.xdja.im.base.frame.view;

import android.support.annotation.NonNull;

import com.xdja.im.base.frame.BaseView;
import com.xdja.im.base.frame.Presenter;

/**
 * @Package: com.xdja.im.base.frame.view
 * @Author: xdjaxa
 * @Creation: 2017-05-15 10:04
 * @Version V1.0
 * @Description:
 */
public interface PagerAdapterView<P extends Presenter, D> extends BaseView<P> {

    /**
     * 适配器相关的View被新创建出来
     */
    void onViewCreate();

    /**
     * 关联Activity生命周期#onResume
     */
    void onViewResume();

    /**
     * 关联Activity生命周期#onPause
     */
    void onViewPause();

    /**
     * 关联Activity生命周期#onDestory
     */
    void onViewDestroy();

    /**
     * 视图数据发生更新,增加此接口，减少不必要的数据更新
     *
     * @param position   当前Item位置
     * @param dataSource 数据
     */
    void onViewUpdate(int position, @NonNull D dataSource);

    /**
     * 绑定数据源到View上
     *
     * @param position   当前Item位置
     * @param dataSource 数据
     */
    void bindDataSource(int position, @NonNull D dataSource);
}
