package com.xdja.im.core.callback;

import com.xdja.im.core.model.account.AccountBean;
import com.xdja.im.core.model.account.AccountType;

/**
 * @Package: com.xdja.im.core.model.account
 * @Author: xdjaxa
 * @Creation: 2017-04-17 21:05
 * @Version V1.0
 * @Description: 联系人回调接口，用于sdk调用上层接口
 */
public interface AccountCallback {

    /**
     * 获取联系人信息，用于sdk获取上层数据回调接口
     *
     * @param accountId 联系人Id
     * @param type      联系人类型
     * @return 联系人信息
     */
    AccountBean getAccount(String accountId, AccountType type);
}
