package com.xdja.im.core.model.message;

import android.support.annotation.NonNull;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.file.FileInfo;

/**
 * @Package: com.xdja.im.core.model
 * @Author: xdjaxa
 * @Creation: 2017-04-11 14:37
 * @Version V1.0
 * @Description:IM消息类型定义
 */
public class TalkMessageBean implements Comparable<TalkMessageBean> {

    /**
     * 消息ID，唯一
     */
    private long id;
    /**
     * 消息内容
     */
    protected String content;
    /**
     * 消息类型（0：文本，1:图片，2：语音，3:文件）
     */
    @ConstDef.MsgType
    private int messageType = ConstDef.MSG_TYPE_TEXT;
    /**
     * 消息状态
     */
    @ConstDef.MsgState
    private int messageState = ConstDef.STATE_SEND_FAILED;
    /**
     * 是否为自己发送的消息
     */
    private boolean isMine = false;
    /**
     * 展示时间
     */
    private long showTime;

    /**
     * 闪信持续时间（非正数为非闪信）
     */
    private int limitTime = 0;
    /**
     * 消息发送发标识
     */
    private String from;
    /**
     * 消息接收方标识
     */
    private String to;
    /**
     * 是否为群发消息
     */
    private boolean isGroupMsg = false;
    /**
     * 发送方卡ID
     */
    private String senderCardId;
    /**
     * 是否是闪信
     */
    private boolean isBomb = false;
    /**
     * 文件消息
     */
    private FileInfo fileInfo;
    /**
     * 失败原因
     */
    private int failCode;

    public TalkMessageBean() {
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public int getMessageType() {
        return messageType;
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    @ConstDef.MsgState
    public int getMessageState() {
        return messageState;
    }

    public void setMessageState(int messageState) {
        this.messageState = messageState;
    }

    public boolean isMine() {
        return isMine;
    }

    public void setMine(boolean mine) {
        isMine = mine;
    }

    public long getShowTime() {
        return showTime;
    }

    public void setShowTime(long showTime) {
        this.showTime = showTime;
    }

    public int getLimitTime() {
        return limitTime;
    }

    public void setLimitTime(int limitTime) {
        this.limitTime = limitTime;
    }

    public String getFrom() {
        return from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public boolean isGroupMsg() {
        return isGroupMsg;
    }

    public void setGroupMsg(boolean groupMsg) {
        isGroupMsg = groupMsg;
    }

    public String getSenderCardId() {
        return senderCardId;
    }

    public void setSenderCardId(String senderCardId) {
        this.senderCardId = senderCardId;
    }

    public boolean isBomb() {
        return isBomb;
    }

    public void setBomb(boolean bomb) {
        isBomb = bomb;
    }

    public FileInfo getFileInfo() {
        return fileInfo;
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    public int getFailCode() {
        return failCode;
    }

    public void setFailCode(int failCode) {
        this.failCode = failCode;
    }

    @Override
    public String toString() {
        return "TalkMessageBean{" +
                "id=" + id +
                ", content='" + content + '\'' +
                ", messageType=" + messageType +
                ", messageState=" + messageState +
                ", isMine=" + isMine +
                ", showTime=" + showTime +
                ", limitTime=" + limitTime +
                ", from='" + from + '\'' +
                ", to='" + to + '\'' +
                ", isGroupMsg=" + isGroupMsg +
                ", senderCardId='" + senderCardId + '\'' +
                ", isBomb=" + isBomb +
                ", fileInfo=" + fileInfo +
                ", failCode=" + failCode +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        TalkMessageBean that = (TalkMessageBean) o;

        return getId() == that.getId();

    }

    @Override
    public int hashCode() {
        return (int) (getId() ^ (getId() >>> 32));
    }

    @Override
    public int compareTo(@NonNull TalkMessageBean o) {
        return this.getShowTime() - o.getShowTime() > 0 ? 1 : -1;
    }

    /**
     * COPY构造函数
     *
     * @param bean
     */
    public TalkMessageBean(TalkMessageBean bean) {
        isMine = bean.isMine();
        showTime = bean.getShowTime();
        content = bean.getContent();
        to = bean.getTo();
        failCode = bean.getFailCode();
        id = bean.getId();
        fileInfo = bean.getFileInfo() != null ?
                new FileInfo(bean.getFileInfo()) : null;
        from = bean.getFrom();
        isBomb = bean.isBomb();
        isGroupMsg = bean.isGroupMsg();
        senderCardId = bean.getSenderCardId();
        limitTime = bean.getLimitTime();
        messageType = bean.getMessageType();
    }
}
