package com.xdja.im.core.model.message.file;

import com.xdja.im.core.config.ConstDef;

/**
 * @Package: com.xdja.im.core.model
 * @Author: xdjaxa
 * @Date: 2017-04-10 20:38
 * @Version V1.0
 * @Comment:文件信息描述类
 */
public class FileInfo {
    /**
     * 文件id
     */
    private long talkMessageId;
    /**
     * 文件路径
     */
    private String filePath;
    /**
     * 文件名称
     */
    private String fileName;
    /**
     * 文件总大小
     */
    private long fileSize;
    /**
     * 文件已传输大小
     */
    private long translateSize;
    /**
     * 文件传输百分比
     */
    private int translatePercent;
    /**
     * 文件后缀
     */
    private String suffix;
    /**
     * 文件属性
     */
    @ConstDef.FileProperty
    private int fileProperty;
    /**
     * 文件类型(语音、视频、图片、文件)
     */
    @ConstDef.FileType
    private int fileType;
    /**
     * 文件状态
     */
    @ConstDef.FileState
    private int fileState;

    public long getTalkMessageId() {
        return talkMessageId;
    }

    public void setTalkMessageId(long talkMessageId) {
        this.talkMessageId = talkMessageId;
    }

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public long getFileSize() {
        return fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public long getTranslateSize() {
        return translateSize;
    }

    public void setTranslateSize(long translateSize) {
        this.translateSize = translateSize;
    }

    public int getTranslatePercent() {
        return translatePercent;
    }

    public void setTranslatePercent(int translatePercent) {
        this.translatePercent = translatePercent;
    }

    public String getSuffix() {
        return suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @ConstDef.FileProperty
    public int getFileProperty() {
        return fileProperty;
    }

    public void setFileProperty(int fileProperty) {
        this.fileProperty = fileProperty;
    }

    @ConstDef.FileType
    public int getFileType() {
        return fileType;
    }

    public void setFileType(@ConstDef.FileType int fileType) {
        this.fileType = fileType;
    }

    public int getFileState() {
        return fileState;
    }

    public void setFileState(int fileState) {
        this.fileState = fileState;
    }

    @Override
    public String toString() {
        return "FileInfo{" +
                "talkMessageId=" + talkMessageId +
                ", filePath='" + filePath + '\'' +
                ", fileName='" + fileName + '\'' +
                ", fileSize=" + fileSize +
                ", translateSize=" + translateSize +
                ", suffix='" + suffix + '\'' +
                ", fileType=" + fileType +
                ", fileState=" + fileState +
                '}';
    }

    public FileInfo() {

    }

    public FileInfo(FileInfo fInfo) {
        filePath = fInfo.getFilePath();
        fileName = fInfo.getFileName();
        fileSize = fInfo.getFileSize();
        translateSize = fInfo.getTranslateSize();
        translatePercent = fInfo.getTranslatePercent();
        suffix = fInfo.getSuffix();
        fileType = fInfo.getFileType();
        fileProperty = fInfo.getFileProperty();
        talkMessageId = fInfo.getTalkMessageId();
        fileState = fInfo.getFileState();
    }
}
