package com.xdja.im.core.repository.impl.datasource;

import com.xdja.im.common.database.helper.IMSettingHelper;
import com.xdja.im.common.database.helper.MXSettingHelper;
import com.xdja.im.common.persistent.PreferencesUtil;
import com.xdja.im.core.model.param.SessionParam;
import com.xdja.im.core.model.param.SettingParam;
import com.xdja.im.core.repository.interf.datasource.DiskDataStore;

import java.util.List;

import javax.inject.Inject;

import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

/**
 * @Package: com.xdja.im.core.repository.impl.datasource
 * @Author: xdjaxa
 * @Creation: 2017-04-11 14:02
 * @Version V1.0
 * @Description:
 */
public class DiskDataStoreImpl implements DiskDataStore {

    private PreferencesUtil preferencesUtil;

    @Inject
    public DiskDataStoreImpl(PreferencesUtil preferencesUtil) {
        this.preferencesUtil = preferencesUtil;
    }

    @Override
    public void setSessionTop(String sessionFlag, final boolean isTop, Subscriber<Boolean> subscriber) {
        Observable.just(sessionFlag)
                .subscribeOn(Schedulers.newThread())
                .flatMap(new Func1<String, Observable<Boolean>>() {
                    @Override
                    public Observable<Boolean> call(String sessionFlag) {
                        boolean ret = MXSettingHelper.setSessionTop(sessionFlag, isTop);
                        if (!ret) {
                            return Observable.error(new Exception("Save session error."));
                        }
                        return Observable.just(ret);
                    }
                })
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(subscriber);
    }

    @Override
    public void setSessionDisturb(String sessionFlag, final boolean isDisturb, Subscriber<Boolean> subscriber) {
        Observable.just(sessionFlag)
                .subscribeOn(Schedulers.newThread())
                .flatMap(new Func1<String, Observable<Boolean>>() {
                    @Override
                    public Observable<Boolean> call(String sessionFlag) {
                        boolean ret = MXSettingHelper.setSessionDisturb(sessionFlag, isDisturb);
                        if (!ret) {
                            return Observable.error(new Exception("Save session error."));
                        }
                        return Observable.just(ret);
                    }
                })
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(subscriber);
    }

    @Override
    public void setReceiveMode(String sessionFlag, final boolean isOpen, Subscriber<Boolean> subscriber) {
        Observable.just(sessionFlag)
                .subscribeOn(Schedulers.newThread())
                .flatMap(new Func1<String, Observable<Boolean>>() {
                    @Override
                    public Observable<Boolean> call(String sessionFlag) {
                        boolean ret = MXSettingHelper.setReceiveMode(sessionFlag, isOpen);
                        if (!ret) {
                            return Observable.error(new Exception("Save session error."));
                        }
                        return Observable.just(ret);
                    }
                })
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(subscriber);
    }

    @Override
    public void saveDraftContent(String sessionFlag, final String content, final long draftTime,
                                 Subscriber<Boolean> subscriber) {
        Observable.just(sessionFlag)
                .subscribeOn(Schedulers.newThread())
                .flatMap(new Func1<String, Observable<Boolean>>() {
                    @Override
                    public Observable<Boolean> call(String sessionFlag) {
                        boolean ret = MXSettingHelper.insertDraft(sessionFlag, content, draftTime);
                        if (!ret) {
                            return Observable.error(new Exception("Save draft error."));
                        }
                        return Observable.just(ret);
                    }
                })
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(subscriber);
    }

    @Override
    public void clearDraftContent(String sessionFlag, final long draftTime, Subscriber<Boolean> subscriber) {
        Observable.just(sessionFlag)
                .subscribeOn(Schedulers.newThread())
                .flatMap(new Func1<String, Observable<Boolean>>() {
                    @Override
                    public Observable<Boolean> call(String sessionFlag) {
                        boolean ret = MXSettingHelper.clearDraft(sessionFlag, draftTime);
                        if (!ret) {
                            return Observable.error(new Exception("Clear draft error."));
                        }
                        return Observable.just(ret);
                    }
                })
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(subscriber);
    }

    @Override
    public void getDraftContent(String sessionFlag, Subscriber<String> subscriber) {
        Observable.just(sessionFlag)
                .subscribeOn(Schedulers.newThread())
                .flatMap(new Func1<String, Observable<String>>() {
                    @Override
                    public Observable<String> call(String sessionFlag) {
                        String content = MXSettingHelper.getDraftContent(sessionFlag);
                        return Observable.just(content);
                    }
                })
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(subscriber);
    }

    @Override
    public void loadSessionParam(String sessionFlag, Subscriber<SessionParam> subscriber) {
        Observable.just(sessionFlag)
                .subscribeOn(Schedulers.newThread())
                .flatMap(new Func1<String, Observable<SessionParam>>() {
                    @Override
                    public Observable<SessionParam> call(String sessionFlag) {
                        SessionParam param = MXSettingHelper.getSessionParam(sessionFlag);
                        if (param == null) {
                            return Observable.error(new Exception("Load session param is null."));
                        }
                        return Observable.just(param);
                    }
                })
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(subscriber);
    }

    @Override
    public void loadAllSessionParams(Subscriber<List<SessionParam>> subscriber) {
        Observable.just("")
                .subscribeOn(Schedulers.newThread())
                .flatMap(new Func1<String, Observable<List<SessionParam>>>() {
                    @Override
                    public Observable<List<SessionParam>> call(String s) {
                        List<SessionParam> params = MXSettingHelper.getAllSessionParams();
                        return Observable.just(params);
                    }
                })
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(subscriber);
    }

    @Override
    public void deleteSessionParam(final String sessionFlag, Subscriber<Boolean> subscriber) {
        Observable.just(sessionFlag)
                .subscribeOn(Schedulers.newThread())
                .flatMap(new Func1<String, Observable<Boolean>>() {
                    @Override
                    public Observable<Boolean> call(String s) {
                        /*boolean ret = MXSettingHelper.deleteOnlyDraft(sessionFlag);
                        if (!ret) {
                            return Observable.error(new Exception("Save session error."));
                        }*/

                        //产品需求：删除会话需要保留置顶和免打扰
                        MXSettingHelper.deleteOnlyDraft(sessionFlag);
                        return Observable.just(true);
                    }
                })
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(subscriber);
    }

    @Override
    public void deleteAllSessionParams(Subscriber<Boolean> subscriber) {
        Observable.just("")
                .subscribeOn(Schedulers.newThread())
                .flatMap(new Func1<String, Observable<Boolean>>() {
                    @Override
                    public Observable<Boolean> call(String s) {
                        boolean ret = MXSettingHelper.deleteAllSessionParams();
                        if (!ret) {
                            return Observable.error(new Exception("Save session error."));
                        }
                        return Observable.just(ret);
                    }
                })
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(subscriber);
    }

    //***************************************************************
    //***********************以下接口保存IM设置信息**********************
    //***************************************************************

    @Override
    public void loadSettingParams(Subscriber<SettingParam> subscriber) {
        Observable.just("")
                .subscribeOn(Schedulers.newThread())
                .flatMap(new Func1<String, Observable<SettingParam>>() {
                    @Override
                    public Observable<SettingParam> call(String s) {
                        SettingParam settingParam = IMSettingHelper.getSettingParam();
                        if (settingParam == null) {
                            return Observable.error(new Exception("Save session error."));
                        }
                        return Observable.just(settingParam);
                    }
                })
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(subscriber);
    }
}
