package com.xdja.im.core.repository.interf.im;

import com.xdja.im.core.config.ConstDef;
import com.xdja.im.core.model.message.TalkMessageBean;
import com.xdja.im.core.model.message.TalkSessionBean;
import com.xdja.im.core.model.message.file.FileInfo;

import java.util.List;

/**
 * @Package: com.xdja.im.core.repository.interf
 * @Author: xdjaxa
 * @Creation: 2017-04-11 11:08
 * @Version V1.0
 * @Description:IM业务层数据回调句柄
 */
public interface IMProxyCallBack {

    /**
     * 初始化SDK完成
     */
    @ConstDef.CallBackHandleState
    int onInitFinished();

    /**
     * 初始化SDK失败
     *
     * @return
     */
    @ConstDef.CallBackHandleState
    int onInitFailed();

    /**
     * 会话列表变更回调事件
     *
     * @param talkId 有变更的会话
     * @param action 更改动作
     * @return 回调函数是否处理
     */
    //@ConstDef.CallBackHandleState
    //int onTalkListChanged(long talkId, @ConstDef.ActionRefCon int action);

    /**
     * 消息列表变更回调事件
     *
     * @param msgId  消息ID
     * @param action 变更动作
     * @return 回调函数是否处理
     */
    //@ConstDef.CallBackHandleState
    //int onMessageListChanged(long msgId, @ConstDef.ActionRefMsg int action);

    /**
     * 创建新的会话事件回调
     *
     * @param talkSessionBean 已增加会话对象
     * @return 回调函数是否处理
     */
    @ConstDef.CallBackHandleState
    int onCreateNewSession(TalkSessionBean talkSessionBean);

    /**
     * 删除会话事件回调
     *
     * @param talkSessionBean 待删除会话对象
     * @return 回调函数是否处理
     */
    @ConstDef.CallBackHandleState
    int onDeleteSession(TalkSessionBean talkSessionBean);

    /**
     * 刷新单条会话回调
     *
     * @param talkSessionBean 待刷新会话对象
     * @return 回调函数是否处理
     */
    @ConstDef.CallBackHandleState
    int onRefreshSession(TalkSessionBean talkSessionBean);

    /**
     * 接收到新消息
     *
     * @param talkMessageBean 消息对象
     * @return 回调函数是否处理
     */
    @ConstDef.CallBackHandleState
    int onReceiveNewMessage(String account, List<TalkMessageBean> talkMessageBean);

    /**
     * 新消息提醒，用于状态栏
     *
     * @param talkMessageBean
     * @return
     */
    @ConstDef.CallBackHandleState
    int onRemainNewMessage(TalkSessionBean session, List<TalkMessageBean> talkMessageBean);

    /**
     * 删除消息
     *
     * @param talkMessageBean 待删除消息对象
     * @return 回调函数是否处理
     */
    @ConstDef.CallBackHandleState
    int onDeleteMessage(String account, TalkMessageBean talkMessageBean);

    /**
     * 刷新单条消息
     *
     * @param talkMessageBean 待刷新消息对象
     * @return 回调函数是否处理
     */
    @ConstDef.CallBackHandleState
    int onRefreshMessage(String account, TalkMessageBean talkMessageBean);

    /**
     * 刷新消息列表
     *
     * @return 回调函数是否处理
     */
    @ConstDef.CallBackHandleState
    int refreshMessageList();

    /**
     * 发送文件消息，文件上传进度更新
     *
     * @param talkId   发送文件的会话信息
     * @param msgId    发送文件的消息信息
     * @param fileInfo 当前发送的文件信息
     * @param progress 文件上传进度百分比
     * @return 0 回调函数未处理， 1 回调函数已处理
     */
    @ConstDef.CallBackHandleState
    int onSendFileProgressUpdate(String talkId, long msgId, FileInfo fileInfo, int progress);

    /**
     * 发送文件消息，文件上传完成
     *
     * @param talkId   发送文件的会话信息
     * @param msgId    发送文件的消息信息
     * @param fileInfo 当前发送的文件信息
     * @return 0 回调函数未处理， 1 回调函数已处理
     */
    @ConstDef.CallBackHandleState
    int onSendFileFinished(String talkId, long msgId, FileInfo fileInfo);

    /**
     * 发送文件消息失败
     *
     * @param talkId   发送文件的会话信息
     * @param msgId    发送文件的消息信息
     * @param fileInfo 当前发送的文件信息
     * @param code     错误码
     * @return 0 回调函数未处理， 1 回调函数已处理
     */
    @ConstDef.CallBackHandleState
    int onSendFileFailed(String talkId, long msgId, FileInfo fileInfo, int code);

    /**
     * 接收文件消息，文件下载进度更新
     *
     * @param talkId   接收文件的会话信息
     * @param msgId    接收文件的消息信息
     * @param fileInfo 当前接收的文件信息
     * @param progress 文件下载进度百分比
     * @return 0 回调函数未处理， 1 回调函数已处理
     */
    @ConstDef.CallBackHandleState
    int onReceiveFileProgressUpdate(String talkId, long msgId, FileInfo fileInfo, int progress);

    /**
     * 接收文件消息，文件下载完成
     *
     * @param talkId   接收文件的会话信息
     * @param msgId    接收文件的消息信息
     * @param fileInfo 当前接收的文件信息
     * @return 0 回调函数未处理， 1 回调函数已处理
     */
    @ConstDef.CallBackHandleState
    int onReceiveFileFinished(String talkId, long msgId, FileInfo fileInfo);

    /**
     * 接收文件消息失败
     *
     * @param talkId   接收文件的会话信息
     * @param msgId    接收文件的消息信息
     * @param fileInfo 当前接收的文件信息
     * @param code     错误码
     * @return 0 回调函数未处理， 1 回调函数已处理
     */
    @ConstDef.CallBackHandleState
    int onReceiveFileFailed(String talkId, long msgId, FileInfo fileInfo, int code);

    /**
     * 接收文件消息暂停
     *
     * @param talkId   接收文件的会话信息
     * @param msgId    接收文件的消息信息
     * @param fileInfo 当前接收的文件信息
     * @return 0 回调函数未处理， 1 回调函数已处理
     */
    @ConstDef.CallBackHandleState
    int onReceiveFilePaused(String talkId, long msgId, FileInfo fileInfo);

}
